package io.xiaper.mq.stomp.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.simp.broker.BrokerAvailabilityEvent;
import org.springframework.stereotype.Component;

/**
 * indicates when the broker becomes available/unavailable
 *
 * https://docs.spring.io/spring/docs/current/spring-framework-reference/web.html#websocket-stomp-appplication-context-events
 * @author xiaper.io
 */
@Component
public class StompBrokerAvailabilityListener implements ApplicationListener<BrokerAvailabilityEvent> {

    private static final Logger logger = LoggerFactory.getLogger(StompBrokerAvailabilityListener.class);

    /**
     * 来自ApplicationListener的接口
     * 监听 "system" connection to the broker is lost and re-established
     *
     * TODO: SimpMessagingTemplate should subscribe to this event and avoid sending messages at times when the broker is not available.
     * TODO: In any case, SimpMessagingTemplate should be prepared to handle MessageDeliveryException when sending a message.
     *
     * TODO: 持久化断开、建立连接时间，并在建立连接后通知前端
     *
     * @param brokerAvailabilityEvent event
     */
    @Override
    public void onApplicationEvent(BrokerAvailabilityEvent brokerAvailabilityEvent) {
        //
        if (brokerAvailabilityEvent.isBrokerAvailable()) {
            logger.info("mq broker available: " + brokerAvailabilityEvent.toString());
        } else {
            logger.error("lost connection to mq broker: " + brokerAvailabilityEvent.toString());
        }
    }

}
