package io.xiaper.mq.stomp.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionConnectEvent;

/**
 * 客户端新连接建立通知
 * published when a new STOMP CONNECT is received indicating the start of a new client session.
 *
 * https://docs.spring.io/spring/docs/current/spring-framework-reference/web.html#websocket-stomp-appplication-context-events
 * @author xiaper.io
 */
@Component
public class StompConnectListener implements ApplicationListener<SessionConnectEvent> {

    private static final Logger logger = LoggerFactory.getLogger(StompConnectListener.class);

    @Override
    public void onApplicationEvent(SessionConnectEvent sessionConnectEvent) {
//         logger.info(sessionConnectEvent.toString());
    }
}
