package io.xiaper.mq.stomp.listener;

import io.xiaper.jpa.constant.StatusConsts;
import io.xiaper.jpa.model.Browse;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.*;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.StatusService;
import io.xiaper.mq.service.redis.RedisConnectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionConnectedEvent;

import java.security.Principal;
import java.util.Optional;

/**
 * published shortly after a SessionConnectEvent when the broker has sent a STOMP CONNECTED frame in response to the CONNECT
 *
 * https://docs.spring.io/spring/docs/current/spring-framework-reference/web.html#websocket-stomp-appplication-context-events
 * @author xiaper.io
 */
@Component
public class StompConnectedListener implements ApplicationListener<SessionConnectedEvent> {

    private static final Logger logger = LoggerFactory.getLogger(StompConnectedListener.class);

    /**
     * 通过simpMessagingTemplate向浏览器发送消息
     */
    @Autowired
    SimpMessagingTemplate simpMessagingTemplate;

//    @Autowired
//    RabbitTemplate rabbitTemplate;

    @Autowired
    UserRepository userRepository;

    @Autowired
    StatusRepository statusRepository;

    @Autowired
    SubscribeRepository subscribeRepository;

    @Autowired
    MessageRepository messageRepository;

    @Autowired
    BrowseRepository browseRepository;

    @Autowired
    ThreadRepository threadRepository;

    @Autowired
    RedisConnectService redisConnectService;

    @Autowired
    StatusService statusService;

    @Autowired
    MessageService messageService;

    /**
     * 监听来自stomp，也即web端的连接事件
     *
     * TODO: 如果是客服账号，则根据所在工作组type添加订阅, pubSub, roundRobin 等
     *  每个登录客户端一个queue
     *  queue = username +'.'+ sessionId
     *  routeKey = username
     *
     * @param sessionConnectedEvent
     */
    @Override
    public void onApplicationEvent(SessionConnectedEvent sessionConnectedEvent) {
        logger.info(sessionConnectedEvent.toString());

        MessageHeaders headers = sessionConnectedEvent.getMessage().getHeaders();
        Principal principal = SimpMessageHeaderAccessor.getUser(headers);
        if (principal == null) {
            return;
        }
        Optional<User> userOptional = userRepository.findByUsername(principal.getName());
        if (!userOptional.isPresent()) {
            return;
        }
        User user = userOptional.get();
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);

        // 更新连线状态
        redisConnectService.updateConnectedStatus(user);

        // 通知上线
        messageService.notifyConnected(user);

        // logger.info("sessionId: {}, uid: {}", sessionId, user.getUid());

        // TODO: 更新网页在线状态, 断开重连的情况，sessionId是否跟之前一样？如果不一样，则无意义
        Optional<Browse> browseOptional = browseRepository.findFirstBySessionIdAndVisitor(sessionId, user);
        if (user.isVisitor() && browseOptional.isPresent()) {
            logger.warn("online");
            browseOptional.get().setActioned(null);
            browseRepository.save(browseOptional.get());
        }

        // 持久化，用户上线
//        Status status = new Status();
//        status.setStatus(StatusConsts.USER_STATUS_CONNECTED);
//        status.setSessionId(sessionId);
//        status.setUser(user);
//        // FIXME： 访客肯定是web端，对于客服有可能是web/mac/windows端
//        if (user.getClient() != null) {
//            status.setClient(user.getClient());
//        }
//        statusRepository.save(status);

        // TODO: 在公司内部通知所有同事连接状态
        if (!user.isVisitor()) {
            statusService.notifyConnectionStatus(user, StatusConsts.USER_STATUS_CONNECTED);
        }



    }

}

