package io.xiaper.mq.stomp.listener;

import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.SubscribeRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.redis.RedisTopicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;

import java.security.Principal;
import java.util.Optional;

/**
 * published when a new STOMP SUBSCRIBE is received.
 *
 * https://docs.spring.io/spring/docs/current/spring-framework-reference/web.html#websocket-stomp-appplication-context-events
 * @author xiaper.io
 */
@Component
public class StompSubscribeListener implements ApplicationListener<SessionSubscribeEvent> {

    private static final Logger logger = LoggerFactory.getLogger(StompSubscribeListener.class);

    @Autowired
    UserRepository userRepository;

    @Autowired
    ThreadRepository threadRepository;

    @Autowired
    SubscribeRepository subscribeRepository;

    @Autowired
    MessageRepository messageRepository;

    @Autowired
    RedisTopicService redisTopicService;

    /**
     * 监听来自stomp，也即web端的订阅事件
     *
     * @param sessionSubscribeEvent event
     */
    @Override
    public void onApplicationEvent(SessionSubscribeEvent sessionSubscribeEvent) {
        logger.info(sessionSubscribeEvent.toString());

        //
        MessageHeaders headers = sessionSubscribeEvent.getMessage().getHeaders();
        Principal principal = SimpMessageHeaderAccessor.getUser(headers);
        if (principal == null) {
            return;
        }
        Optional<User> userOptional = userRepository.findByUsername(principal.getName());
        if (!userOptional.isPresent()) {
            return;
        }
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        String destination = SimpMessageHeaderAccessor.getDestination(headers);
        logger.info("subscribe: " + destination);

        /**
         * 处理topic/thread会话订阅事件
         * destination格式：/topic/thread.201807172109261
         */
//        String topicThreadPrefix = "/topic/thread";
//        if (destination.startsWith(topicThreadPrefix)) {
//            //
//            String[] splitSlash = destination.split("/");
//            String[] splitDot = splitSlash[splitSlash.length - 1].split("[.]");
//            String threadTid = splitDot[splitDot.length - 1];
//
//            // 对应thread
//            Optional<Thread> threadOptional = threadRepository.findByTid(threadTid);
//            if (threadOptional.isPresent()) {
//                // 设置sessionId
//                threadOptional.get().setSessionId(sessionId);
//                threadRepository.save(threadOptional.get());
//
//                // FIXME: nested exception is javax.persistence.NonUniqueResultException: query did not return a unique result: 2
//                // 如果subscribe库里面没有，则持久化，用户加入会话
//                Optional<Subscribe> subscribeOptional = subscribeRepository.findFirstByThreadAndUser(threadOptional.get(), userOptional.get());
//                if (!subscribeOptional.isPresent()) {
//                    Subscribe subscribe = new Subscribe();
//                    subscribe.setThread(threadOptional.get());
//                    subscribe.setUser(userOptional.get());
//                    subscribeRepository.save(subscribe);
//                }
//
//                // 通知相关用户
//                Optional<User> userNotification = userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
//                if (userNotification.isPresent()) {
//                    //
////                    Message message = new Message();
////                    message.setMid(JpaUtil.randomId());
////                    message.setThread(threadOptional.get());
////                    message.setType(TypeConsts.MESSAGE_TYPE_NOTIFICATION);
////
////                    String content = userOptional.get().getName() + " 进入";
////                    message.setContent(content);
////                    message.setUser(userNotification.get());
////                    // 持久化
////                    messageRepository.save(message);
//
//                    // 通知进入会话
//                    // FIXME: 增加通过RabbitMq发送
////                    String topic = "/topic/thread." + threadTid;
////                    simpMessagingTemplate.convertAndSend(topic,  message);
//                }
//
//            }
//        } else {
//            // 其他topic订阅事件
//        }


    }

}
