package io.xiaper.mq.webscoket;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * https://docs.spring.io/spring/docs/current/spring-framework-reference/web.html#websocket-server
 *
 * 测试链接：
 *  http://localhost:8000/visitor/wss
 *
 * @author xiaper.io
 */
@Component
public class WebSocketMessageHandler extends TextWebSocketHandler {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    List<WebSocketSession> sessions = new CopyOnWriteArrayList<>();

    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        // The WebSocket has been closed
        logger.info("session {}, status {}", session.toString(), status.toString());

        sessions.remove(session);
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        // The WebSocket has been opened
        // I might save this session object so that I can send messages to it outside of this method
        logger.info("session {} connection established", session.toString());

        //the messages will be broadcasted to all users.
        sessions.add(session);

        // Let's send the first message
        session.sendMessage(new TextMessage("You are now connected to the server. This is the first message."));
    }

    @Override
    protected void handleTextMessage(WebSocketSession session, TextMessage textMessage) {

        String content = textMessage.getPayload();

        // A message has been received
        logger.info("Message received: {}", content);

        try {
            session.sendMessage(new TextMessage(new StringBuffer(content).reverse().toString()));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }



}
