/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.config;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.annotation.RabbitListenerConfigurer;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistrar;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;

@EnableRabbit
@Configuration
public class RabbitConfig
implements RabbitListenerConfigurer {
    @Bean
    public TopicExchange topicExchange() {
        return new TopicExchange("amq.topic");
    }

    @Bean
    public Queue platformQueue() {
        return new Queue("byteDesk.from.platform", true, false, false);
    }

    @Bean
    public Binding bindingTopicPlatformQueue(TopicExchange topicExchange, Queue platformQueue) {
        return BindingBuilder.bind((Queue)platformQueue).to(topicExchange).with("message.platform.#");
    }

    @Bean
    public Queue companyQueue() {
        return new Queue("byteDesk.from.subDomain", true, false, false);
    }

    @Bean
    public Binding bindingTopicCompanyQueue(TopicExchange topicExchange, Queue companyQueue) {
        return BindingBuilder.bind((Queue)companyQueue).to(topicExchange).with("message.subDomain.#");
    }

    @Bean
    public Queue workGroupQueue() {
        return new Queue("byteDesk.from.workGroup", true, false, false);
    }

    @Bean
    public Binding bindingTopicWorkGroupQueue(TopicExchange topicExchange, Queue workGroupQueue) {
        return BindingBuilder.bind((Queue)workGroupQueue).to(topicExchange).with("message.workGroup.#");
    }

    @Bean
    public Queue groupQueue() {
        return new Queue("byteDesk.from.group", true, false, false);
    }

    @Bean
    public Binding bindingTopicGroupQueue(TopicExchange topicExchange, Queue groupQueue) {
        return BindingBuilder.bind((Queue)groupQueue).to(topicExchange).with("message.group.#");
    }

    @Bean
    public Queue contactQueue() {
        return new Queue("byteDesk.from.contact", true, false, false);
    }

    @Bean
    public Binding bindingTopicContactQueue(TopicExchange topicExchange, Queue contactQueue) {
        return BindingBuilder.bind((Queue)contactQueue).to(topicExchange).with("message.contact.#");
    }

    @Bean
    public Queue threadQueue() {
        return new Queue("byteDesk.from.thread", true, false, false);
    }

    @Bean
    public Binding bindingTopicThreadQueue(TopicExchange topicExchange, Queue threadQueue) {
        return BindingBuilder.bind((Queue)threadQueue).to(topicExchange).with("message.thread.#");
    }

    @Bean
    public Queue userQueue() {
        return new Queue("byteDesk.from.user", true, false, false);
    }

    @Bean
    public Binding bindingTopicUserQueue(TopicExchange topicExchange, Queue userQueue) {
        return BindingBuilder.bind((Queue)userQueue).to(topicExchange).with("message.user.#");
    }

    @Bean
    public Queue mqttMessageQueue() {
        return new Queue("byteDesk.from.mqtt.message", true, false, false);
    }

    @Bean
    public Binding bindingTopicMqttMessageQueue(TopicExchange topicExchange, Queue mqttMessageQueue) {
        return BindingBuilder.bind((Queue)mqttMessageQueue).to(topicExchange).with("message.mqtt");
    }

    @Bean
    public Queue mqttReceiptQueue() {
        return new Queue("byteDesk.from.mqtt.receipt", true, false, false);
    }

    @Bean
    public Binding bindingTopicMqttReceiptQueue(TopicExchange topicExchange, Queue mqttReceiptQueue) {
        return BindingBuilder.bind((Queue)mqttReceiptQueue).to(topicExchange).with("receipt.mqtt");
    }

    @Bean
    public Queue mqttWebRTCQueue() {
        return new Queue("byteDesk.from.mqtt.webrtc", true, false, false);
    }

    @Bean
    public Binding bindingTopicMqttWebRTCQueue(TopicExchange topicExchange, Queue mqttWebRTCQueue) {
        return BindingBuilder.bind((Queue)mqttWebRTCQueue).to(topicExchange).with("webrtc.mqtt");
    }

    @Bean
    public Queue mqttStatusQueue() {
        return new Queue("byteDesk.from.mqtt.status", false, false, true);
    }

    @Bean
    public Binding bindingTopicMqttStatusQueue(TopicExchange topicExchange, Queue mqttStatusQueue) {
        return BindingBuilder.bind((Queue)mqttStatusQueue).to(topicExchange).with("status.mqtt");
    }

    @Bean
    public Queue mqttLastWillQueue() {
        return new Queue("byteDesk.from.mqtt.lastWill", false, false, true);
    }

    @Bean
    public Binding bindingTopicMqttLastWillQueue(TopicExchange topicExchange, Queue mqttLastWillQueue) {
        return BindingBuilder.bind((Queue)mqttLastWillQueue).to(topicExchange).with("lastWill.mqtt");
    }

    @Bean
    public Queue mqttMessageProtobufQueue() {
        return new Queue("byteDesk.from.mqtt.message.protobuf", true, false, false);
    }

    @Bean
    public Binding bindingTopicMqttProtobufMessageQueue(TopicExchange topicExchange, Queue mqttMessageProtobufQueue) {
        return BindingBuilder.bind((Queue)mqttMessageProtobufQueue).to(topicExchange).with("message.mqtt.protobuf");
    }

    @Bean
    public Queue mqttReceiptProtobufQueue() {
        return new Queue("byteDesk.from.mqtt.receipt.protobuf", true, false, false);
    }

    @Bean
    public Binding bindingTopicMqttProtobufReceiptQueue(TopicExchange topicExchange, Queue mqttReceiptProtobufQueue) {
        return BindingBuilder.bind((Queue)mqttReceiptProtobufQueue).to(topicExchange).with("receipt.mqtt.protobuf");
    }

    @Bean
    public Queue mqttStatusProtobufQueue() {
        return new Queue("byteDesk.from.mqtt.status.protobuf", false, false, true);
    }

    @Bean
    public Binding bindingTopicMqttStatusProtobufQueue(TopicExchange topicExchange, Queue mqttStatusProtobufQueue) {
        return BindingBuilder.bind((Queue)mqttStatusProtobufQueue).to(topicExchange).with("status.mqtt.protobuf");
    }

    @Bean
    public Queue mqttLastWillProtobufQueue() {
        return new Queue("byteDesk.from.mqtt.lastWill.protobuf", false, false, true);
    }

    @Bean
    public Binding bindingTopicMqttLastWillProtobufQueue(TopicExchange topicExchange, Queue mqttLastWillProtobufQueue) {
        return BindingBuilder.bind((Queue)mqttLastWillProtobufQueue).to(topicExchange).with("lastWill.mqtt.protobuf");
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter((MessageConverter)this.producerJackson2MessageConverter());
        return rabbitTemplate;
    }

    @Bean
    public Jackson2JsonMessageConverter producerJackson2MessageConverter() {
        return new Jackson2JsonMessageConverter();
    }

    @Bean
    public MappingJackson2MessageConverter consumerJackson2MessageConverter() {
        return new MappingJackson2MessageConverter();
    }

    @Bean
    public DefaultMessageHandlerMethodFactory messageHandlerMethodFactory() {
        DefaultMessageHandlerMethodFactory factory = new DefaultMessageHandlerMethodFactory();
        factory.setMessageConverter((org.springframework.messaging.converter.MessageConverter)this.consumerJackson2MessageConverter());
        return factory;
    }

    public void configureRabbitListeners(RabbitListenerEndpointRegistrar registrar) {
        registrar.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)this.messageHandlerMethodFactory());
    }
}

