/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.xiaper.jpa.model.BrowseInvite;
import io.xiaper.jpa.model.Group;
import io.xiaper.jpa.model.Invite;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Notice;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.Transfer;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.StatusService;
import io.xiaper.mq.service.ThreadService;
import io.xiaper.mq.service.TransformService;
import io.xiaper.mq.service.redis.RedisConnectService;
import io.xiaper.mq.service.redis.RedisStatisticService;
import io.xiaper.mq.service.wechat.WeChatMiniService;
import io.xiaper.mq.service.wechat.WeChatMpService;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class RabbitMessageListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    MessageService messageService;
    @Autowired
    SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    StatusService statusService;
    @Autowired
    RedisConnectService redisConnectService;
    @Autowired
    RedisStatisticService redisStatisticService;
    @Autowired
    WeChatMpService weChatMpService;
    @Autowired
    WeChatMiniService weChatMiniService;
    @Autowired
    TransformService transformService;
    @Autowired
    ThreadService threadService;

    @RabbitListener(queues={"#{platformQueue.name}"})
    public void receivePlatformMessage(Message message) {
        this.logger.info("receive from platformQueue message queue, content: {}", (Object)message.toString());
    }

    @RabbitListener(queues={"#{companyQueue.name}"})
    public void receiveCompanyMessage(Message message) {
        this.logger.info("receive from companyQueue message queue, content: {}", (Object)message.toString());
        if (null != message.getUser()) {
            String subDomain = message.getUser().getSubDomain();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/subDomain." + subDomain), (Object)message);
        }
    }

    @RabbitListener(queues={"#{workGroupQueue.name}"})
    public void receiveWorkGroupMessage(Message message) {
        this.logger.info("receive from workGroupQueue message queue, content: {}", (Object)message.toString());
        if (message.getType().equals("notification_queue")) {
            Map messageMap = this.transformService.getWorkGroupQueueMessageMap(message);
            String wid = message.getWid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/workGroup." + wid), (Object)messageMap);
        } else if (message.getType().equals("notification_browse_start") || message.getType().equals("notification_browse_end")) {
            Map messageMap = this.transformService.getWorkGroupBrowseMessageMap(message);
            String wid = message.getWid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/workGroup." + wid), (Object)messageMap);
        } else {
            String wid = message.getWid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/workGroup." + wid), (Object)message);
        }
    }

    @RabbitListener(queues={"#{groupQueue.name}"})
    public void receiveGroupMessage(Message message) {
        this.logger.info("receive from groupQueue message queue, content: {}", (Object)message.toString());
        Map messageMap = this.transformService.getGroupMessageMap(message);
        String gid = message.getGid();
        this.simpMessagingTemplate.convertAndSend((Object)("/topic/group." + gid), (Object)messageMap);
    }

    @RabbitListener(queues={"#{contactQueue.name}"})
    public void receiveContactMessage(Message message) {
        this.logger.info("receive from contactQueue message queue, content: {}", (Object)message.toString());
        String cid = message.getCid();
        if (message.getType().equals("notification_preview")) {
            Map messageMap = this.transformService.getContactPreviewMessageMap(message);
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/contact." + cid), (Object)messageMap);
        } else if (message.getType().equals("notification_receipt")) {
            Map messageMap = this.transformService.getContactReceiptMessageMap(message);
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/contact." + cid), (Object)messageMap);
        } else if (message.getType().equals("notification_webrtc_invite") || message.getType().equals("notification_webrtc_offer_audio") || message.getType().equals("notification_webrtc_offer_video") || message.getType().equals("notification_webrtc_answer") || message.getType().equals("notification_webrtc_candidate") || message.getType().equals("notification_webrtc_cancel") || message.getType().equals("notification_webrtc_reject") || message.getType().equals("notification_webrtc_accept") || message.getType().equals("notification_webrtc_close")) {
            Map messageMap = this.transformService.getContactMessageMap(message);
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/contact." + cid), (Object)messageMap);
        } else {
            User user = message.getThread().getAgent();
            User contact = message.getThread().getContact();
            Thread thread = this.threadService.getContactThread(user, contact);
            message.setThread(thread);
            Map messageMap = this.transformService.getContactMessageMap(message);
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/contact." + cid), (Object)messageMap);
            user = message.getThread().getAgent();
            contact = message.getThread().getContact();
            thread = this.threadService.getContactThread(contact, user);
            message.setThread(thread);
            messageMap = this.transformService.getContactMessageMap(message);
            String uid = message.getUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/contact." + uid), (Object)messageMap);
        }
    }

    @RabbitListener(queues={"#{threadQueue.name}"})
    public void receiveThreadMessage(Message message) {
        this.logger.info("receive from threadQueue message queue, content: {}", (Object)message.toString());
        if (null != message.getThread()) {
            String tid = message.getThread().getTid();
            if (message.getType().equals("notification_preview")) {
                Map messageMap = this.transformService.getThreadPreviewMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else if (message.getType().equals("notification_receipt")) {
                Map messageMap = this.transformService.getThreadReceiptMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else if (message.getType().equals("text") || message.getType().equals("image") || message.getType().equals("file") || message.getType().equals("voice") || message.getType().equals("video") || message.getType().equals("shortvideo") || message.getType().equals("location") || message.getType().equals("link") || message.getType().equals("commodity") || message.getType().equals("red_packet") || message.getType().equals("notification_agent_close") || message.getType().equals("notification_visitor_close") || message.getType().equals("notification_auto_close") || message.getType().equals("notification_invite_rate") || message.getType().equals("notification_rate_result") || message.getType().equals("notification_webrtc_invite") || message.getType().equals("notification_webrtc_cancel") || message.getType().equals("notification_webrtc_accept") || message.getType().equals("notification_webrtc_reject") || message.getType().equals("notification_webrtc_ready") || message.getType().equals("notification_webrtc_busy") || message.getType().equals("notification_webrtc_close")) {
                Map messageMap = this.transformService.getThreadContentMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else if (message.getType().equals("notification_connect") || message.getType().equals("notification_disconnect")) {
                Map messageMap = this.transformService.getThreadConnectionMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else if (message.getType().equals("notification_webrtc_candidate")) {
                Map messageMap = this.transformService.getThreadWebRtcCandidateMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else if (message.getType().equals("notification_webrtc_offer_video") || message.getType().equals("notification_webrtc_offer_audio") || message.getType().equals("notification_webrtc_answer")) {
                Map messageMap = this.transformService.getThreadWebRtcOfferAnswerMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else {
                this.logger.warn("\u5176\u4ed6\u6d88\u606f {}", (Object)message.getType());
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)message);
            }
            this.pushToWeChat(message);
        }
    }

    private void pushToWeChat(Message message) {
        if (message.getType().equals("text") || message.getType().equals("image") || message.getType().equals("file") || message.getType().equals("voice") || message.getType().equals("video") || message.getType().equals("shortvideo") || message.getType().equals("location") || message.getType().equals("link")) {
            if (message.getThread().getVisitor().isWeChatMp() && !message.getUser().isWeChatMp()) {
                this.weChatMpService.pushToWeChat(message);
            } else if (message.getThread().getVisitor().isWeChatMini() && !message.getUser().isWeChatMini()) {
                this.weChatMiniService.pushToWeChat(message);
            }
        }
    }

    @RabbitListener(queues={"#{userQueue.name}"})
    public void receiveUserMessage(Message message) {
        this.logger.info("receive from userQueue message queue, content: {}", (Object)message.toString());
        if (message.getType().equals("notification_transfer")) {
            Map messageMap = this.transformService.getUserTransferMessageMap(message);
            Transfer threadTransfer = message.getTransfer();
            if (null != threadTransfer) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + threadTransfer.getToUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_transfer_accept") || message.getType().equals("notification_transfer_reject")) {
            Map messageMap = this.transformService.getUserTransferAcceptRejectMessageMap(message);
            Transfer threadTransfer = message.getTransfer();
            if (null != threadTransfer) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + threadTransfer.getFromUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_invite")) {
            Map messageMap = this.transformService.getUserInviteMessageMap(message);
            Invite threadInvite = message.getInvite();
            if (null != threadInvite) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + threadInvite.getToUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_invite_accept") || message.getType().equals("notification_invite_reject")) {
            Map messageMap = this.transformService.getUserInviteAcceptRejectMessageMap(message);
            Invite threadInvite = message.getInvite();
            if (null != threadInvite) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + threadInvite.getFromUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_browse_invite")) {
            Map messageMap = this.transformService.getUserBrowseInviteMessageMap(message);
            BrowseInvite browseInvite = message.getBrowseInvite();
            if (null != browseInvite) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + browseInvite.getToUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_receipt")) {
            Map messageMap = this.transformService.getUserReceiptMessageMap(message);
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + message.getUser().getUid()), (Object)messageMap);
        } else if (message.getType().equals("notification_kickoff")) {
            Map messageMap = this.transformService.getUserKickoffMessageMap(message);
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + message.getUser().getUid()), (Object)messageMap);
        } else if (message.getType().equals("notification_thread") || message.getType().equals("notification_thread_reentry")) {
            Map messageMap = this.transformService.getUserThreadMessageMap(message);
            User agent = message.getThread().getAgent();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + agent.getUid()), (Object)messageMap);
        } else if (message.getType().equals("notification_group_create")) {
            Map messageMap = this.transformService.getUserGroupCreateMessageMap(message);
            Group group = message.getGroup();
            Set userSet = group.getMembers();
            for (User user : userSet) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + user.getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_group_invite")) {
            Map messageMap = this.transformService.getUserGroupInviteMessageMap(message);
            String uid = message.getCid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_apply")) {
            Map messageMap = this.transformService.getUserGroupApplyMessageMap(message);
            Notice notice = message.getNotice();
            Set admins = notice.getUsers();
            for (User admin : admins) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + admin.getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_group_apply_approve")) {
            Map messageMap = this.transformService.getUserGroupApplyApproveMessageMap(message);
            Notice notice = message.getNotice();
            String uid = notice.getUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_apply_deny")) {
            Map messageMap = this.transformService.getUserGroupApplyDenyMessageMap(message);
            Notice notice = message.getNotice();
            String uid = notice.getUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_transfer")) {
            Map messageMap = this.transformService.getUserGroupTransferMessageMap(message);
            Notice notice = message.getNotice();
            Set admins = notice.getUsers();
            for (User admin : admins) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + admin.getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_group_transfer_accept")) {
            Map messageMap = this.transformService.getUserGroupTransferAcceptMessageMap(message);
            Notice notice = message.getNotice();
            if (notice != null) {
                if (notice.getUser() != null) {
                    String uid = notice.getUser().getUid();
                    this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
                } else {
                    this.logger.info("notice.getUser is null");
                }
            } else {
                this.logger.info("notice is null");
            }
        } else if (message.getType().equals("notification_group_transfer_reject")) {
            Map messageMap = this.transformService.getUserGroupTransferRejectMessageMap(message);
            Notice notice = message.getNotice();
            String uid = notice.getUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_kick")) {
            Map messageMap = this.transformService.getUserGroupKickMessageMap(message);
            String uid = message.getCid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_mute")) {
            Map messageMap = this.transformService.getUserGroupMuteMessageMap(message);
            String uid = message.getCid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_unmute")) {
            Map messageMap = this.transformService.getUserGroupUnMuteMessageMap(message);
            String uid = message.getCid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_set_admin")) {
            Map messageMap = this.transformService.getUserGroupSetAdminMessageMap(message);
            String uid = message.getCid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_unset_admin")) {
            Map messageMap = this.transformService.getUserGroupUnSetAdminMessageMap(message);
            String uid = message.getCid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (!(message.getType().equals("notification_group_withdraw") || message.getType().equals("notification_group_dismiss") || message.getType().equals("notification_webrtc_invite") || message.getType().equals("notification_webrtc_cancel") || message.getType().equals("notification_webrtc_offer_video") || message.getType().equals("notification_webrtc_offer_audio") || message.getType().equals("notification_webrtc_answer") || message.getType().equals("notification_webrtc_candidate") || message.getType().equals("notification_webrtc_accept") || message.getType().equals("notification_webrtc_reject") || message.getType().equals("notification_webrtc_ready") || message.getType().equals("notification_webrtc_busy") || message.getType().equals("notification_webrtc_close") || null == message.getThread() || null == message.getThread().getAgent())) {
            User agent = message.getThread().getAgent();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + agent.getUid()), (Object)message);
        }
    }

    @RabbitListener(queues={"#{mqttMessageQueue.name}"})
    public void receiveMqttMessage(String mqttMessage) {
        this.logger.info("receive from mqtt messageQueue: {}", (Object)mqttMessage);
        JSONObject jsonObject = JSON.parseObject((String)mqttMessage);
        String tid = jsonObject.getString("tid");
        String type = jsonObject.getString("type");
        String client = jsonObject.getString("client");
        String content = jsonObject.getString("content");
        String username = jsonObject.getString("username");
        String status = jsonObject.getString("status");
        String localId = jsonObject.getString("localId");
        String sessionType = jsonObject.getString("sessionType");
        String version = jsonObject.getString("version");
        this.logger.info("type {}, client {}, content: {}, username {}, tid {}, sessionType {}, localId {}, status {}", new Object[]{type, client, content, username, tid, sessionType, localId, status});
        if (type == null) {
            return;
        }
        Optional userOptional = this.userRepository.findByUsername(username);
        Message message = new Message();
        message.setType(type);
        message.setClient(client);
        message.setStatus(status);
        message.setLocalId(localId);
        message.setSessionType(sessionType);
        if (type.equals("text")) {
            message.setContent(content);
        } else if (type.equals("image")) {
            message.setImageUrl(content);
        }
        this.messageService.routeMessage(sessionType, tid, message, (User)userOptional.get());
    }

    @RabbitListener(queues={"#{mqttReceiptQueue.name}"})
    public void receiveMqttReceipt(String mqttMessage) {
        this.logger.info("receive from mqtt receipt: {}", (Object)mqttMessage);
        JSONObject jsonObject = JSON.parseObject((String)mqttMessage);
        String clientId = jsonObject.getString("clientId");
        String mId = jsonObject.getString("mId");
        String status = jsonObject.getString("status");
        String version = jsonObject.getString("version");
        this.logger.info("clientId {}, mId {}, status  {}, version {}", new Object[]{clientId, mId, status, version});
        if (clientId == null) {
            return;
        }
        String[] clients = clientId.split("/");
        if (clients.length < 3) {
            this.logger.error("clientId {} \u683c\u5f0f\u9519\u8bef", (Object)clientId);
            return;
        }
        String username = clients[0];
        String client = clients[1];
        String uuid = clients[2];
        this.logger.info("username {}, client {}, uuid {}", new Object[]{username, client, uuid});
        this.messageService.noticeReceipt(username, mId, status);
    }

    @RabbitListener(queues={"#{mqttWebRTCQueue.name}"})
    public void receiveMqttWebRTC(String mqttMessage) {
        this.logger.info("receive from mqtt webrtc: {}", (Object)mqttMessage);
        JSONObject jsonObject = JSON.parseObject((String)mqttMessage);
        String clientId = jsonObject.getString("clientId");
        String localId = jsonObject.getString("localId");
        String sessionType = jsonObject.getString("sessionType");
        String type = jsonObject.getString("type");
        String uuid = jsonObject.getString("uuid");
        String content = jsonObject.getString("content");
        String version = jsonObject.getString("version");
        if (clientId == null) {
            return;
        }
        String[] clients = clientId.split("/");
        if (clients.length < 3) {
            this.logger.error("clientId {} \u683c\u5f0f\u9519\u8bef", (Object)clientId);
            return;
        }
        String username = clients[0];
        String client = clients[1];
        String randomId = clients[2];
        this.logger.info("username {}, client {}, randomId {}", new Object[]{username, client, randomId});
        if (!sessionType.equals("thread")) {
            if (sessionType.equals("contact")) {
                Optional userOptional = this.userRepository.findByUsername(username);
                if (userOptional.isPresent()) {
                    Message message = new Message();
                    message.setClient(client);
                    message.setType(type);
                    message.setLocalId(localId);
                    message.setSessionType(sessionType);
                    if (type.equals("notification_webrtc_invite")) {
                        message.setContent(((User)userOptional.get()).getNickname() + "\u9080\u8bf7\u89c6\u9891");
                    } else if (type.equals("notification_webrtc_offer_audio") || type.equals("notification_webrtc_offer_video") || type.equals("notification_webrtc_answer")) {
                        message.setSessionDescription((Object)content);
                    } else if (type.equals("notification_webrtc_candidate")) {
                        message.setCandidate((Object)content);
                    } else if (type.equals("notification_webrtc_cancel")) {
                        message.setContent(((User)userOptional.get()).getNickname() + "\u53d6\u6d88\u89c6\u9891");
                    } else if (type.equals("notification_webrtc_reject")) {
                        message.setContent(((User)userOptional.get()).getNickname() + "\u62d2\u7edd\u89c6\u9891");
                    } else if (type.equals("notification_webrtc_accept")) {
                        message.setContent(((User)userOptional.get()).getNickname() + "\u63a5\u53d7\u89c6\u9891");
                    } else if (type.equals("notification_webrtc_close")) {
                        message.setContent(((User)userOptional.get()).getNickname() + "\u7ed3\u675f\u89c6\u9891");
                    }
                    this.messageService.routeContactMessage(uuid, message, (User)userOptional.get());
                }
            } else if (sessionType.equals("group")) {
                // empty if block
            }
        }
    }

    @RabbitListener(queues={"#{mqttStatusQueue.name}"})
    public void receiveMqttStatus(String mqttMessage) {
        this.logger.info("receive from mqtt statusQueue: {}", (Object)mqttMessage);
        JSONObject jsonObject = JSON.parseObject((String)mqttMessage);
        String clientId = jsonObject.getString("clientId");
        String status = jsonObject.getString("status");
        this.logger.info("clientId {}, status  {}", (Object)clientId, (Object)status);
        if (clientId == null) {
            return;
        }
        String[] clients = clientId.split("/");
        if (clients.length < 3) {
            this.logger.error("clientId {} \u683c\u5f0f\u9519\u8bef", (Object)clientId);
            return;
        }
        String username = clients[0];
        String client = clients[1];
        String uuid = clients[2];
        this.logger.info("username {}, client {}, uuid {}", new Object[]{username, client, uuid});
        Optional userOptional = this.userRepository.findByUsername(username);
        if (userOptional.isPresent()) {
            this.statusService.saveStatus(status, client, (User)userOptional.get());
            if (status.equals("connected")) {
                this.redisConnectService.updateConnectedStatus((User)userOptional.get());
                this.messageService.notifyConnected((User)userOptional.get());
                this.statusService.kickoff((User)userOptional.get(), clientId);
            } else if (status.equals("disconnected")) {
                this.redisConnectService.updateDisconnectedStatus((User)userOptional.get());
                this.messageService.notifyDisconnected((User)userOptional.get());
            }
        } else {
            this.logger.warn("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bbe\u7f6emqtt\u5ba2\u6237\u7aef\u72b6\u6001");
        }
    }

    @RabbitListener(queues={"#{mqttLastWillQueue.name}"})
    public void receiveMqttLastWill(String mqttMessage) {
        this.logger.info("receive from mqtt lastWill: {}", (Object)mqttMessage);
        JSONObject jsonObject = JSON.parseObject((String)mqttMessage);
        String clientId = jsonObject.getString("clientId");
        String status = jsonObject.getString("status");
        this.logger.info("clientId {}, status  {}", (Object)clientId, (Object)status);
        if (clientId == null) {
            return;
        }
        String[] clients = clientId.split("/");
        if (clients.length < 3) {
            this.logger.error("clientId {} \u683c\u5f0f\u9519\u8bef", (Object)clientId);
            return;
        }
        String username = clients[0];
        String client = clients[1];
        String uuid = clients[2];
        this.logger.info("username {}, client {}, uuid {}", new Object[]{username, client, uuid});
        Optional userOptional = this.userRepository.findByUsername(username);
        if (userOptional.isPresent()) {
            this.statusService.saveStatus(status, client, (User)userOptional.get());
            this.redisConnectService.updateDisconnectedStatus((User)userOptional.get());
            this.messageService.notifyDisconnected((User)userOptional.get());
        } else {
            this.logger.info("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bbe\u7f6emqtt\u5ba2\u6237\u7aef\u65ad\u5f00\u72b6\u6001");
        }
    }

    @RabbitListener(queues={"#{mqttMessageProtobufQueue.name}"})
    public void receiveMqttMessageProtobuf(String mqttMessage) {
        this.logger.info("receive from mqtt messageProtobufQueue: {}", (Object)mqttMessage);
    }
}

