/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.converter;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;

public class ProtobufMessageConverter
implements MessageConverter {
    private static Map<String, MessageLite.Builder> builderMap = new HashMap<String, MessageLite.Builder>();

    public Message toMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        String messageType = object.getClass().getSimpleName();
        if (!builderMap.containsKey(messageType)) {
            throw new MessageConversionException("not support message type:" + messageType);
        }
        messageProperties.setHeader("messageType", (Object)messageType);
        MessageLite messageLite = (MessageLite)object;
        return new Message(messageLite.toByteArray(), messageProperties);
    }

    public Object fromMessage(Message message) throws MessageConversionException {
        String messageType = message.getMessageProperties().getHeaders().get("messageType").toString();
        if (!builderMap.containsKey(messageType)) {
            throw new MessageConversionException("not support message type:" + messageType);
        }
        try {
            MessageLite.Builder builder = builderMap.get(messageType).clear();
            builder = builder.mergeFrom(message.getBody());
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new MessageConversionException("deserialize message error", (Throwable)e);
        }
    }
}

