/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp;

import io.xiaper.mq.stomp.StompHandshakeInterceptor;
import java.net.InetSocketAddress;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.stomp.StompReactorNettyCodec;
import org.springframework.messaging.tcp.reactor.ReactorNettyCodec;
import org.springframework.messaging.tcp.reactor.ReactorNettyTcpClient;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocketMessageBroker
public class StompConfig
implements WebSocketMessageBrokerConfigurer {
    @Value(value="${spring.rabbitmq.host}")
    private String relayHost;
    @Value(value="${spring.rabbitmq.stomp.port}")
    private int relayPort;
    @Value(value="${spring.rabbitmq.username}")
    private String systemLogin;
    @Value(value="${spring.rabbitmq.password}")
    private String systemPasscode;
    @Value(value="${spring.rabbitmq.stomp.login}")
    private String clientLogin;
    @Value(value="${spring.rabbitmq.stomp.passcode}")
    private String clientPasscode;

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/stomp"}).setAllowedOrigins(new String[]{"*"}).withSockJS();
        registry.addEndpoint(new String[]{"/stomp/mini"}).addInterceptors(new HandshakeInterceptor[]{new StompHandshakeInterceptor()}).setAllowedOrigins(new String[]{"*"});
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableStompBrokerRelay(new String[]{"/topic", "/queue"}).setClientLogin(this.clientLogin).setClientPasscode(this.clientPasscode).setSystemLogin(this.systemLogin).setSystemPasscode(this.systemPasscode).setRelayHost(this.relayHost).setRelayPort(this.relayPort);
        config.setApplicationDestinationPrefixes(new String[]{"/app"});
        config.setUserDestinationPrefix("/user");
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setSendTimeLimit(15000).setSendBufferSizeLimit(524288);
        registration.setMessageSizeLimit(131072);
    }

    private ReactorNettyTcpClient<byte[]> createTcpClient() {
        return new ReactorNettyTcpClient(client -> client.addressSupplier(() -> new InetSocketAddress(this.relayHost, this.relayPort)), (ReactorNettyCodec)new StompReactorNettyCodec());
    }
}

