/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp;

import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.ThreadService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.stereotype.Controller;

@Controller
public class StompController {
    private static final Logger logger = LoggerFactory.getLogger(StompController.class);
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    ThreadService threadService;
    @Autowired
    MessageService messageService;

    @MessageMapping(value={"/message"})
    public void message(Principal principal, Message message) {
        logger.info("one message from:" + principal.getName() + " content:" + message.toString());
    }

    @MessageMapping(value={"/{sessionType}.{tid}"})
    public void message(Principal principal, @DestinationVariable(value="sessionType") String sessionType, @DestinationVariable(value="tid") String tid, Message message) {
        logger.info(sessionType + " message from:" + principal.getName() + " tid:" + tid + " content:" + message.toString());
        message.setSessionType(sessionType);
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        this.messageService.routeMessage(sessionType, tid, message, (User)userOptional.get());
    }

    @MessageMapping(value={"/protobuf.{sessionType}.{tid}"})
    public void message(Principal principal, @DestinationVariable(value="sessionType") String sessionType, @DestinationVariable(value="tid") String tid) {
        logger.info("protobuf username: {} sessionType: {}, tid {}", new Object[]{principal.getName(), sessionType, tid});
    }

    @SubscribeMapping(value={"/thread.{threadId}"})
    public List<User> subscribeThread(Principal principal, @DestinationVariable(value="threadId") String threadId) {
        logger.info("subscribe from: " + principal.getName() + " threadId:" + threadId);
        return new ArrayList<User>();
    }

    @MessageMapping(value={"/speak"})
    @SendToUser(value={"/personal"})
    public String speak(@Payload String text, @Header(value="simpSessionId") String sessionId) throws Exception {
        logger.info("\u6536\u5230\u79c1\u4eba\u6d88\u606f:" + text);
        return text;
    }

    @MessageExceptionHandler
    @SendToUser(destinations={"/queue/errors"}, broadcast=false)
    public String handleException(Throwable exception) {
        exception.printStackTrace();
        return exception.getMessage();
    }
}

