/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp.listener;

import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.SubscribeRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.redis.RedisTopicService;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionUnsubscribeEvent;

@Component
public class StompUnsubscribeListener
implements ApplicationListener<SessionUnsubscribeEvent> {
    private static final Logger logger = LoggerFactory.getLogger(StompUnsubscribeListener.class);
    @Autowired
    UserRepository userRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    SubscribeRepository subscribeRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    RedisTopicService redisTopicService;

    public void onApplicationEvent(SessionUnsubscribeEvent sessionUnsubscribeEvent) {
        MessageHeaders headers = sessionUnsubscribeEvent.getMessage().getHeaders();
        Principal principal = SimpMessageHeaderAccessor.getUser((Map)headers);
        if (principal == null) {
            return;
        }
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        if (!userOptional.isPresent()) {
            return;
        }
        String destination = SimpMessageHeaderAccessor.getDestination((Map)headers);
        logger.info("unsubscribe: " + destination);
    }
}

