/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.webscoket;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class WebSocketMessageHandler
extends TextWebSocketHandler {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    List<WebSocketSession> sessions = new CopyOnWriteArrayList<WebSocketSession>();

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        this.logger.info("session {}, status {}", (Object)session.toString(), (Object)status.toString());
        this.sessions.remove(session);
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.logger.info("session {} connection established", (Object)session.toString());
        this.sessions.add(session);
        session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"You are now connected to the server. This is the first message."));
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage textMessage) {
        String content = (String)textMessage.getPayload();
        this.logger.info("Message received: {}", (Object)content);
        try {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)new StringBuffer(content).reverse().toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

