package io.xiaper.webxiaqun.controller;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

import java.security.Principal;

/**
 * @author bytedesk.com on 2019/5/5
 */
@Controller
public class XQRouteController {


    /**
     * 二维码，扫码登录
     *
     * @param principal principal
     * @param model model
     * @return string
     */
    @GetMapping("/xq/qrcode/login")
    public String qrcodeLogin(Principal principal, Model model) {

        return "xqqrcode/login";
    }


    /**
     * 二维码，个人资料
     *
     * @param principal principal
     * @param model model
     * @return string
     */
    @GetMapping("/xq/qrcode/user")
    public String qrcodeUser(Principal principal, Model model) {

        return "xqqrcode/user";
    }

    /**
     * 二维码，群组资料
     *
     * @param principal principal
     * @param model model
     * @return string
     */
    @GetMapping("/xq/qrcode/group")
    public String qrcodeGroup(Principal principal, Model model) {

        return "xqqrcode/group";
    }

}
