/*
 * Decompiled with CFR 0.152.
 */
package x7.core.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import x7.core.bean.Conjunction;
import x7.core.bean.Criteria;
import x7.core.bean.DataPermission;
import x7.core.bean.Distinct;
import x7.core.bean.DomainBuilder;
import x7.core.bean.KV;
import x7.core.bean.MinMax;
import x7.core.bean.PageBuilder;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.bean.Predicate;
import x7.core.bean.Reduce;
import x7.core.bean.Sort;
import x7.core.util.BeanMapUtil;
import x7.core.util.BeanUtilX;
import x7.core.util.StringUtil;
import x7.core.web.Direction;
import x7.core.web.Fetched;
import x7.core.web.MapResult;
import x7.core.web.Paged;

public class CriteriaBuilder {
    private Criteria criteria;
    private CriteriaBuilder instance;
    private PageBuilder pageBuilder = new PageBuilder(){

        @Override
        public PageBuilder scroll(boolean isScroll) {
            CriteriaBuilder.this.criteria.setScroll(isScroll);
            return this;
        }

        @Override
        public PageBuilder rows(int rows) {
            CriteriaBuilder.this.criteria.setRows(rows);
            return this;
        }

        @Override
        public PageBuilder page(int page) {
            CriteriaBuilder.this.criteria.setPage(page);
            return this;
        }

        @Override
        public PageBuilder orderIn(String porperty, List<? extends Object> inList) {
            if (Objects.nonNull(inList) && inList.size() > 0) {
                KV kv = new KV(porperty, inList);
                CriteriaBuilder.this.criteria.getFixedSortList().add(kv);
            }
            return this;
        }

        @Override
        public PageBuilder sort(String orderBy, Direction direction) {
            if (StringUtil.isNullOrEmpty(orderBy)) {
                return this;
            }
            List<Sort> sortList = CriteriaBuilder.this.criteria.getSortList();
            if (sortList == null) {
                sortList = new ArrayList<Sort>();
                CriteriaBuilder.this.criteria.setSortList(sortList);
            }
            Sort sort = new Sort(orderBy, direction);
            sortList.add(sort);
            return this;
        }

        @Override
        public PageBuilder sort(String orderBy, Direction direction, List<Object> optValueList) {
            if (StringUtil.isNullOrEmpty(orderBy)) {
                return this;
            }
            List<Sort> sortList = CriteriaBuilder.this.criteria.getSortList();
            if (sortList == null) {
                sortList = new ArrayList<Sort>();
                CriteriaBuilder.this.criteria.setSortList(sortList);
            }
            Sort sort = new Sort(orderBy, direction);
            sortList.add(sort);
            return this;
        }
    };
    private ConditionBuilder conditionBuilder = new ConditionBuilder(){
        private Criteria.X x = null;

        @Override
        public Criteria.X getX() {
            return this.x;
        }

        @Override
        public void under(Criteria.X x) {
            this.x = x;
        }

        @Override
        public CriteriaBuilder eq(String property, Object value) {
            if (value == null) {
                return CriteriaBuilder.this.instance;
            }
            if (Objects.nonNull(CriteriaBuilder.this.criteria.getParsed()) && BeanUtilX.isBaseType_0(property, value, CriteriaBuilder.this.criteria.getParsed())) {
                return CriteriaBuilder.this.instance;
            }
            if (CriteriaBuilder.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.EQ);
            this.x.setKey(property);
            this.x.setValue(value);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder lt(String property, Object value) {
            if (value == null) {
                return CriteriaBuilder.this.instance;
            }
            if (BeanUtilX.isBaseType_0(property, value, CriteriaBuilder.this.criteria.getParsed())) {
                return CriteriaBuilder.this.instance;
            }
            if (CriteriaBuilder.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.LT);
            this.x.setKey(property);
            this.x.setValue(value);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder lte(String property, Object value) {
            if (value == null) {
                return CriteriaBuilder.this.instance;
            }
            if (BeanUtilX.isBaseType_0(property, value, CriteriaBuilder.this.criteria.getParsed())) {
                return CriteriaBuilder.this.instance;
            }
            if (CriteriaBuilder.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.LTE);
            this.x.setKey(property);
            this.x.setValue(value);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder gt(String property, Object value) {
            if (value == null) {
                return CriteriaBuilder.this.instance;
            }
            if (BeanUtilX.isBaseType_0(property, value, CriteriaBuilder.this.criteria.getParsed())) {
                return CriteriaBuilder.this.instance;
            }
            if (CriteriaBuilder.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.GT);
            this.x.setKey(property);
            this.x.setValue(value);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder gte(String property, Object value) {
            if (value == null) {
                return CriteriaBuilder.this.instance;
            }
            if (BeanUtilX.isBaseType_0(property, value, CriteriaBuilder.this.criteria.getParsed())) {
                return CriteriaBuilder.this.instance;
            }
            if (CriteriaBuilder.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.GTE);
            this.x.setKey(property);
            this.x.setValue(value);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder ne(String property, Object value) {
            if (value == null) {
                return CriteriaBuilder.this.instance;
            }
            if (BeanUtilX.isBaseType_0(property, value, CriteriaBuilder.this.criteria.getParsed())) {
                return CriteriaBuilder.this.instance;
            }
            if (CriteriaBuilder.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.NE);
            this.x.setKey(property);
            this.x.setValue(value);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder like(String property, String value) {
            if (StringUtil.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.LIKE);
            this.x.setKey(property);
            this.x.setValue("%" + value + "%");
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder likeRight(String property, String value) {
            if (StringUtil.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.LIKE);
            this.x.setKey(property);
            this.x.setValue(value + "%");
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder notLike(String property, String value) {
            if (StringUtil.isNullOrEmpty(value)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.NOT_LIKE);
            this.x.setKey(property);
            this.x.setValue("%" + value + "%");
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder between(String property, Object min, Object max) {
            if (min == null || max == null) {
                return CriteriaBuilder.this.instance;
            }
            if (BeanUtilX.isBaseType_0(property, max, CriteriaBuilder.this.criteria.getParsed())) {
                return CriteriaBuilder.this.instance;
            }
            if (CriteriaBuilder.isNullOrEmpty(max)) {
                return CriteriaBuilder.this.instance;
            }
            if (CriteriaBuilder.isNullOrEmpty(min)) {
                return CriteriaBuilder.this.instance;
            }
            MinMax minMax = new MinMax();
            minMax.setMin(min);
            minMax.setMax(max);
            this.x.setPredicate(Predicate.BETWEEN);
            this.x.setKey(property);
            this.x.setValue(minMax);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder in(String property, List<? extends Object> list) {
            if (list == null || list.isEmpty()) {
                return CriteriaBuilder.this.instance;
            }
            ArrayList<Object> tempList = new ArrayList<Object>();
            for (Object object : list) {
                if (Objects.isNull(object) || BeanUtilX.isBaseType_0(property, object, CriteriaBuilder.this.criteria.getParsed()) || tempList.contains(object)) continue;
                tempList.add(object);
            }
            if (tempList.isEmpty()) {
                return CriteriaBuilder.this.instance;
            }
            if (tempList.size() == 1) {
                return this.eq(property, tempList.get(0));
            }
            this.x.setPredicate(Predicate.IN);
            this.x.setKey(property);
            this.x.setValue(tempList);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder nin(String property, List<Object> list) {
            if (list == null || list.isEmpty()) {
                return CriteriaBuilder.this.instance;
            }
            ArrayList<Object> tempList = new ArrayList<Object>();
            for (Object obj : list) {
                if (Objects.isNull(obj) || tempList.contains(obj)) continue;
                tempList.add(obj);
            }
            if (tempList.isEmpty()) {
                return CriteriaBuilder.this.instance;
            }
            if (tempList.size() == 1) {
                return this.ne(property, tempList.get(0));
            }
            this.x.setPredicate(Predicate.NOT_IN);
            this.x.setKey(property);
            this.x.setValue(tempList);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder nonNull(String property) {
            if (StringUtil.isNullOrEmpty(property)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.IS_NOT_NULL);
            this.x.setValue(property);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder isNull(String property) {
            if (StringUtil.isNullOrEmpty(property)) {
                return CriteriaBuilder.this.instance;
            }
            this.x.setPredicate(Predicate.IS_NULL);
            this.x.setValue(property);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder x(String sql) {
            if (StringUtil.isNullOrEmpty(sql)) {
                return CriteriaBuilder.this.instance;
            }
            sql = BeanUtilX.normalizeSql(sql);
            this.x.setPredicate(Predicate.X);
            this.x.setKey(sql);
            this.x.setValue(null);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public CriteriaBuilder x(String sql, List<Object> valueList) {
            if (StringUtil.isNullOrEmpty(sql)) {
                return CriteriaBuilder.this.instance;
            }
            sql = BeanUtilX.normalizeSql(sql);
            this.x.setPredicate(Predicate.X);
            this.x.setKey(sql);
            this.x.setValue(valueList);
            return CriteriaBuilder.this.instance;
        }

        @Override
        public ConditionBuilder beginSub() {
            this.x.setKey(Predicate.SUB.sql());
            this.x.setValue(Predicate.SUB);
            ArrayList<Criteria.X> subList = new ArrayList<Criteria.X>();
            this.x.setSubList(subList);
            Criteria.X from = new Criteria.X();
            from.setPredicate(Predicate.SUB_BEGIN);
            from.setValue(Predicate.SUB_BEGIN);
            subList.add(from);
            Criteria.X xx = new Criteria.X();
            subList.add(xx);
            xx.setParent(this.x);
            CriteriaBuilder.this.conditionBuilder.under(xx);
            return CriteriaBuilder.this.conditionBuilder;
        }
    };

    public PageBuilder paged() {
        return this.pageBuilder;
    }

    public void paged(Paged paged) {
        this.criteria.paged(paged);
        DataPermission.Chain.onBuild(this.criteria, paged);
    }

    public ConditionBuilder and() {
        Criteria.X x = new Criteria.X();
        x.setConjunction(Conjunction.AND);
        x.setValue(Conjunction.AND);
        Criteria.X current = this.conditionBuilder.getX();
        if (current != null) {
            Criteria.X parent = current.getParent();
            if (parent != null) {
                List<Criteria.X> subList = parent.getSubList();
                if (subList != null) {
                    subList.add(x);
                    x.setParent(parent);
                }
            } else {
                this.criteria.add(x);
            }
        } else {
            this.criteria.add(x);
        }
        this.conditionBuilder.under(x);
        return this.conditionBuilder;
    }

    public ConditionBuilder or() {
        Criteria.X x = new Criteria.X();
        x.setConjunction(Conjunction.OR);
        x.setValue(Conjunction.OR);
        Criteria.X current = this.conditionBuilder.getX();
        if (current != null) {
            Criteria.X parent = current.getParent();
            if (parent != null) {
                List<Criteria.X> subList = parent.getSubList();
                if (subList != null) {
                    subList.add(x);
                    x.setParent(parent);
                }
            } else {
                this.criteria.add(x);
            }
        } else {
            this.criteria.add(x);
        }
        this.conditionBuilder.under(x);
        return this.conditionBuilder;
    }

    public CriteriaBuilder endSub() {
        Criteria.X x = new Criteria.X();
        x.setPredicate(Predicate.SUB_END);
        x.setValue(Predicate.SUB_END);
        Criteria.X current = this.conditionBuilder.getX();
        Criteria.X parent = current.getParent();
        if (parent != null) {
            List<Criteria.X> subList = parent.getSubList();
            if (subList != null) {
                subList.add(x);
            }
            this.conditionBuilder.under(parent);
        }
        return this.instance;
    }

    private CriteriaBuilder() {
        this.instance = this;
    }

    private CriteriaBuilder(Criteria criteria) {
        this.criteria = criteria;
        this.instance = this;
    }

    public static CriteriaBuilder buildCondition() {
        Criteria criteria = new Criteria();
        CriteriaBuilder builder = new CriteriaBuilder(criteria);
        return builder;
    }

    public static CriteriaBuilder build(Class<?> clz) {
        Criteria criteria = new Criteria();
        criteria.setClz(clz);
        CriteriaBuilder builder = new CriteriaBuilder(criteria);
        if (criteria.getParsed() == null) {
            Parsed parsed = Parser.get(clz);
            criteria.setParsed(parsed);
        }
        return builder;
    }

    public static CriteriaBuilder build(Class<?> clz, Paged paged) {
        Criteria criteria = new Criteria();
        criteria.setClz(clz);
        CriteriaBuilder builder = new CriteriaBuilder(criteria);
        if (criteria.getParsed() == null) {
            Parsed parsed = Parser.get(clz);
            criteria.setParsed(parsed);
        }
        if (paged != null) {
            builder.paged(paged);
        }
        return builder;
    }

    public static ResultMappedBuilder buildResultMapped(Class<?> clz, Fetched ro) {
        CriteriaBuilder b;
        CriteriaBuilder criteriaBuilder = b = new CriteriaBuilder();
        criteriaBuilder.getClass();
        ResultMappedBuilder builder = criteriaBuilder.new ResultMappedBuilder(clz);
        if (ro != null) {
            builder.xAddResultKey(ro);
            if (ro instanceof Paged) {
                builder.paged((Paged)((Object)ro));
            }
        }
        return builder;
    }

    public static ResultMappedBuilder buildResultMapped(Class<?> clz, MapResult ro) {
        CriteriaBuilder b;
        CriteriaBuilder criteriaBuilder = b = new CriteriaBuilder();
        criteriaBuilder.getClass();
        ResultMappedBuilder builder = criteriaBuilder.new ResultMappedBuilder(clz);
        if (ro != null) {
            builder.xAddResultKey(ro);
            if (ro instanceof Paged) {
                builder.paged((Paged)((Object)ro));
            }
        }
        return builder;
    }

    public static ResultMappedBuilder buildResultMapped(Class<?> clz) {
        CriteriaBuilder b;
        CriteriaBuilder criteriaBuilder = b = new CriteriaBuilder();
        criteriaBuilder.getClass();
        ResultMappedBuilder builder = criteriaBuilder.new ResultMappedBuilder(clz);
        return builder;
    }

    public static DomainObjectBuilder buildDomainObject(Class<?> mainClz, Class<?> withClz) {
        CriteriaBuilder b;
        CriteriaBuilder criteriaBuilder = b = new CriteriaBuilder();
        criteriaBuilder.getClass();
        DomainObjectBuilder builder = criteriaBuilder.new DomainObjectBuilder(mainClz, withClz);
        return builder;
    }

    public Class<?> getClz() {
        return this.criteria.getClz();
    }

    protected static boolean isNullOrEmpty(Object v) {
        Class<?> vType = v.getClass();
        if (vType == String.class) {
            return StringUtil.isNullOrEmpty(v.toString());
        }
        return false;
    }

    public Criteria get() {
        DataPermission.Chain.befroeGetCriteria(this, this.criteria);
        Iterator<Criteria.X> ite = this.criteria.getListX().iterator();
        while (ite.hasNext()) {
            Criteria.X x = ite.next();
            if (!Objects.isNull(x.getConjunction()) || !Objects.isNull(x.getPredicate()) || !Objects.isNull(x.getKey())) continue;
            ite.remove();
        }
        return this.criteria;
    }

    public class DomainObjectBuilder
    extends CriteriaBuilder {
        private DomainBuilder domainBuilder;

        @Override
        public Criteria.DomainObjectCriteria get() {
            return (Criteria.DomainObjectCriteria)super.get();
        }

        private void init() {
            ((CriteriaBuilder)this).instance = (CriteriaBuilder)this;
            Criteria.DomainObjectCriteria domainObjectCriteria = new Criteria.DomainObjectCriteria();
            ((CriteriaBuilder)this).criteria = domainObjectCriteria;
        }

        private void init(Class<?> mainClz, Class<?> withClz) {
            Criteria.DomainObjectCriteria doc = (Criteria.DomainObjectCriteria)((CriteriaBuilder)this).criteria;
            doc.setClz(mainClz);
            doc.setWithClz(withClz);
            Parsed parsed = Parser.get(mainClz);
            doc.setParsed(parsed);
        }

        public DomainObjectBuilder(Class mainClz, Class withClz) {
            this.domainBuilder = new DomainBuilder(){

                @Override
                public DomainBuilder known(List<? extends Object> mainIdList) {
                    DomainObjectBuilder.this.get().setKnownMainIdList(mainIdList);
                    return this;
                }

                @Override
                public DomainBuilder relative(Class relativeClz) {
                    DomainObjectBuilder.this.get().setRelativeClz(relativeClz);
                    return this;
                }

                @Override
                public DomainBuilder on(String mainProperty) {
                    DomainObjectBuilder.this.get().setMainPropperty(mainProperty);
                    return this;
                }

                @Override
                public CriteriaBuilder with(String withProperty) {
                    DomainObjectBuilder.this.get().setWithProperty(withProperty);
                    return CriteriaBuilder.this.instance;
                }
            };
            this.init();
            this.init(mainClz, withClz);
        }

        public DomainBuilder domain() {
            return this.domainBuilder;
        }
    }

    public class ResultMappedBuilder
    extends CriteriaBuilder {
        @Override
        public Criteria.ResultMappedCriteria get() {
            return (Criteria.ResultMappedCriteria)super.get();
        }

        private void init() {
            ((CriteriaBuilder)this).instance = (CriteriaBuilder)this;
            Criteria.ResultMappedCriteria resultMapped = new Criteria.ResultMappedCriteria();
            ((CriteriaBuilder)this).criteria = resultMapped;
        }

        private void init(Class<?> clz) {
            Criteria.ResultMappedCriteria f = (Criteria.ResultMappedCriteria)((CriteriaBuilder)this).criteria;
            f.setClz(clz);
            Parsed parsed = Parser.get(clz);
            f.setParsed(parsed);
        }

        public ResultMappedBuilder(Class<?> clz) {
            this.init();
            this.init(clz);
        }

        private void xAddResultKey(List<String> xExpressionList) {
            for (String xExpression : xExpressionList) {
                this.get().getResultKeyList().add(xExpression);
            }
        }

        private void xAddResultKey(Fetched fetchResult) {
            if (fetchResult == null) {
                return;
            }
            Map<String, Object> resultObjMap = fetchResult.getResultKeyMap();
            if (resultObjMap == null || resultObjMap.isEmpty()) {
                return;
            }
            List<String> xExpressionList = BeanMapUtil.toStringKeyList(resultObjMap);
            this.xAddResultKey(xExpressionList);
        }

        private void xAddResultKey(MapResult mappedKey) {
            if (mappedKey == null) {
                return;
            }
            String[] arr = mappedKey.getResultKeys();
            if (arr == null || arr.length == 0) {
                return;
            }
            List<String> list = Arrays.asList(arr);
            this.xAddResultKey(list);
        }

        public ResultMappedBuilder resultKey(String resultKey) {
            this.get().getResultKeyList().add(resultKey);
            return this;
        }

        @Override
        public void paged(Paged paged) {
            ((CriteriaBuilder)this).criteria.paged(paged);
            DataPermission.Chain.onBuild(((CriteriaBuilder)this).criteria, paged);
        }

        public ResultMappedBuilder distinct(Object ... objs) {
            if (objs == null) {
                throw new RuntimeException("distinct non resultKey");
            }
            Criteria.ResultMappedCriteria resultMapped = this.get();
            Distinct distinct = resultMapped.getDistinct();
            if (Objects.isNull(distinct)) {
                distinct = new Distinct();
                resultMapped.setDistinct(distinct);
            }
            for (Object obj : objs) {
                if (obj instanceof String) {
                    distinct.add(obj.toString());
                    continue;
                }
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (!(value instanceof Map)) continue;
                        Map vMap = (Map)value;
                        for (Object k : vMap.keySet()) {
                            distinct.add(key.toString() + "." + k.toString());
                        }
                    }
                    continue;
                }
                throw new RuntimeException("distinct param suggests String, or Map");
            }
            return this;
        }

        public ResultMappedBuilder groupBy(String property) {
            this.get().setGroupBy(property);
            return this;
        }

        public ResultMappedBuilder reduce(Reduce.ReduceType type, String property) {
            Reduce reduce = new Reduce();
            reduce.setType(type);
            reduce.setProperty(property);
            this.get().getReduceList().add(reduce);
            return this;
        }
    }

    public static interface ConditionBuilder {
        public CriteriaBuilder eq(String var1, Object var2);

        public CriteriaBuilder lt(String var1, Object var2);

        public CriteriaBuilder lte(String var1, Object var2);

        public CriteriaBuilder gt(String var1, Object var2);

        public CriteriaBuilder gte(String var1, Object var2);

        public CriteriaBuilder ne(String var1, Object var2);

        public CriteriaBuilder like(String var1, String var2);

        public CriteriaBuilder likeRight(String var1, String var2);

        public CriteriaBuilder notLike(String var1, String var2);

        public CriteriaBuilder between(String var1, Object var2, Object var3);

        public CriteriaBuilder in(String var1, List<? extends Object> var2);

        public CriteriaBuilder nin(String var1, List<Object> var2);

        public CriteriaBuilder nonNull(String var1);

        public CriteriaBuilder isNull(String var1);

        public CriteriaBuilder x(String var1);

        public CriteriaBuilder x(String var1, List<Object> var2);

        public void under(Criteria.X var1);

        public Criteria.X getX();

        public ConditionBuilder beginSub();
    }
}

