/*
 * Decompiled with CFR 0.152.
 */
package x7.core.util;

import java.io.Serializable;

public class IntMap
implements Serializable {
    private static final long serialVersionUID = 270700123037753057L;
    private int capacity = 1;
    private static final int KEY_BASE = -1;
    private static final int VALUE_BASE = 0;
    private int[] keys;
    private int[] values;

    public IntMap() {
        this.keys = new int[1];
        this.values = new int[1];
        this.keys[0] = -1;
        this.values[0] = 0;
    }

    public IntMap(int capacity) {
        if (capacity < 1) {
            System.out.println(" capacity\u5fc5\u9700\u5927\u4e8e0 ");
        }
        this.capacity = capacity;
        this.create(capacity);
    }

    public int[] keys() {
        int size = this.size();
        int[] newKeys = new int[size];
        int j = 0;
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            if (this.keys[i] == -1) continue;
            newKeys[j++] = this.keys[i];
        }
        return newKeys;
    }

    public int[] values() {
        int size = this.size();
        int[] newValues = new int[size];
        int j = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            if (this.values[i] == -1) continue;
            newValues[j++] = this.values[i];
        }
        return newValues;
    }

    public int get(int key) {
        if (key == -1) {
            System.out.println(" -1 is kept ");
        }
        int index = -1;
        int size = this.keys.length;
        for (int i = 0; i < size; ++i) {
            if (key != this.keys[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return 0;
        }
        return this.values[index];
    }

    public void put(int key, int value) {
        if (key == -1 || value == -1) {
            System.out.println(" -1 is kept ");
        }
        int size = this.keys.length;
        int index = -1;
        for (int i = 0; i < size; ++i) {
            if (this.keys[i] != key && this.keys[i] != -1) continue;
            this.keys[i] = key;
            index = i;
            break;
        }
        if (index == -1) {
            int[] newKeys = new int[size + 1];
            int[] newValues = new int[size + 1];
            System.arraycopy(this.keys, 0, newKeys, 0, size);
            System.arraycopy(this.values, 0, newValues, 0, size);
            this.keys = newKeys;
            this.values = newValues;
            index = size;
            this.keys[index] = key;
        }
        this.values[index] = value;
    }

    public void putAll(IntMap map) {
        for (int key : map.keys()) {
            int origin = this.get(key);
            this.put(key, origin + map.get(key));
        }
    }

    public int remove(int key) throws Exception {
        if (key == -1) {
            throw new Exception(" -1 is kept ");
        }
        int index = -1;
        int size = this.keys.length;
        for (int i = 0; i < size; ++i) {
            if (key != this.keys[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return -1;
        }
        int result = this.values[index];
        this.keys[index] = -1;
        this.values[index] = -1;
        int keySize = this.keys.length;
        int length = 0;
        for (int i = 0; i < keySize; ++i) {
            if (this.keys[i] != -1) continue;
            ++length;
        }
        if (length > this.capacity * 2) {
            size = this.size();
            size = size < this.capacity ? this.capacity : size;
            int[] newKeys = new int[size];
            int[] newValues = new int[size];
            int j = 0;
            for (int i = 0; i < keySize; ++i) {
                if (this.keys[i] == -1) continue;
                newKeys[j] = this.keys[i];
                newValues[j] = this.values[i];
                ++j;
            }
            while (j < size) {
                newKeys[j] = -1;
                newValues[j] = -1;
                ++j;
            }
            this.keys = newKeys;
            this.values = newValues;
        }
        return result;
    }

    public boolean containsKey(int key) {
        int size = this.keys.length;
        for (int i = 0; i < size; ++i) {
            if (this.keys[i] != key) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(int value) {
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            if (this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int result = 0;
        int size = this.keys.length;
        for (int i = 0; i < size; ++i) {
            if (this.keys[i] == -1) continue;
            ++result;
        }
        return result;
    }

    public void claer() {
        this.create(this.capacity);
    }

    private void create(int capacity) {
        int size = capacity;
        this.keys = new int[size];
        this.values = new int[size];
        for (int i = 0; i < size; ++i) {
            this.keys[i] = -1;
            this.values[i] = -1;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.keys[i] == -1) continue;
            sb.append("\"").append(this.keys[i]).append("\"").append(":").append("\"").append(this.values[i]).append("\"");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

