/*
 * Decompiled with CFR 0.152.
 */
package x7.core.util;

import java.io.ByteArrayOutputStream;

public class IntUtil {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '}'};

    public static String c10to64(long num) {
        return IntUtil.toUnsignedString(num, 6);
    }

    public static String c10to32(long num) {
        return IntUtil.toUnsignedString(num, 5);
    }

    public static String c10to16(long num) {
        return Long.toHexString(num).toUpperCase();
    }

    public static String c10to8(long num) {
        return Long.toOctalString(num);
    }

    public static String c10to4(long num) {
        return IntUtil.toUnsignedString(num, 2);
    }

    public static String c10to2(long num) {
        return Long.toBinaryString(num);
    }

    public static long c64to10(String num) {
        return IntUtil.toUnsignedLong(num, 6);
    }

    public static long c32to10(String num) {
        return IntUtil.toUnsignedLong(num, 5);
    }

    public static long c16to10(String num) {
        return IntUtil.toUnsignedLong(num, 4);
    }

    public static long c8to10(String num) {
        return IntUtil.toUnsignedLong(num, 3);
    }

    public static long c4to10(String num) {
        return IntUtil.toUnsignedLong(num, 2);
    }

    public static long c2to10(String num) {
        return IntUtil.toUnsignedLong(num, 1);
    }

    private static String toUnsignedString(long i, int shift) {
        int bit = (int)Math.pow(2.0, shift);
        char[] buf = new char[bit];
        int charPos = bit;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = digits[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        return new String(buf, charPos, bit - charPos);
    }

    private static long toUnsignedLong(String src, int shift) {
        int len;
        int bit = (int)Math.pow(2.0, shift);
        long result = 0L;
        int num = len = src.length();
        int b = 0;
        String single = null;
        for (int i = 0; i < len; ++i) {
            single = src.substring(i, i + 1);
            single = String.valueOf(IntUtil.getNum(single));
            b = Integer.parseInt(single);
            result += (long)b * (long)Math.pow(bit, num - 1);
            --num;
        }
        return result;
    }

    public static int getNum(String single) {
        int result = 0;
        for (int n = 0; n < 64; ++n) {
            String str = String.valueOf(digits[n]);
            if (!single.equals(str)) continue;
            result = n;
            break;
        }
        return result;
    }

    public static long s2l(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static int s2i(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int force_s2i(String str) {
        byte[] bs = str.getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean isstart = false;
        for (int i = 0; i < bs.length; ++i) {
            if (bs[i] >= 48 && bs[i] <= 57) {
                isstart = true;
                baos.write(bs[i]);
                continue;
            }
            if (isstart) break;
        }
        return IntUtil.s2i(baos.toString());
    }
}

