/*
 * Decompiled with CFR 0.152.
 */
package x7.core.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class TimeUtil {
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    public static final long HALF_HOUR = 1800000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_MINUTE = 60000L;

    public static boolean isSameDay(long time1, long time2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(time1);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(time2);
        return c1.get(5) == c2.get(5) && c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }

    public static boolean isSameMonth(long time1, long time2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(time1);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(time2);
        return c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static String toMillisString() {
        return "" + System.currentTimeMillis();
    }

    public static long toMillis(String strMillis) {
        return Long.valueOf(strMillis);
    }

    public static long toMillis(Date time) {
        if (time == null) {
            return 0L;
        }
        return time.getTime();
    }

    public static long toMillis() {
        return System.currentTimeMillis();
    }

    public static long nextDay(long millis) {
        return millis + 86400000L;
    }

    public static long nextWeek(long millis) {
        return millis + 604800000L;
    }

    public static long nextHour(long millis) {
        return millis + 3600000L;
    }

    public static long nextHalfHour(long millis) {
        return millis + 1800000L;
    }

    public static long lastWeek(long millis) {
        return millis - 604800000L;
    }

    public static long lastDay(long millis) {
        return millis - 86400000L;
    }

    public static long lastHour(long millis) {
        return millis - 3600000L;
    }

    public static long lastMinute(long millis) {
        return millis - 60000L;
    }

    public static long CLOCK_0() {
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long CLOCK_0(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long scheduledAt(int HOUR) {
        return TimeUtil.scheduledAt(HOUR, 0);
    }

    public static long scheduledAt(int HOUR, int minute) {
        long scheduledAt = TimeUtil.CLOCK_0() + 3600000L * (long)HOUR + 60000L * (long)minute;
        if (scheduledAt <= TimeUtil.now()) {
            scheduledAt += 86400000L;
        }
        return scheduledAt;
    }

    public static long fixedAt(int HOUR, int minute) {
        return TimeUtil.CLOCK_0() + 3600000L * (long)HOUR + 60000L * (long)minute;
    }

    public static long getTime(String timeStr, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date d = sdf.parse(timeStr);
            return d.getTime();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long format(String ss) {
        String[] tt = ss.split(":");
        int[] unit = new int[]{60, 60, 60, 24};
        long total = 0L;
        int j = 0;
        int x = 1;
        int i = tt.length - 1;
        while (i >= 0) {
            String t = tt[i];
            int time = Integer.parseInt(t);
            total += (long)(time *= x);
            x *= unit[j];
            --i;
            ++j;
        }
        return total;
    }

    public static boolean isSameDay(Date d1, long l2) {
        Date d2 = new Date();
        d2.setTime(l2);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String str1 = sdf.format(d1);
        String str2 = sdf.format(d2);
        return str1.equals(str2);
    }

    public static boolean isToday(Date date) {
        return TimeUtil.isSameDay(date.getTime(), TimeUtil.now());
    }

    public static boolean isToday(long time) {
        return TimeUtil.isSameDay(time, TimeUtil.now());
    }

    public static boolean isThisMonth(long time) {
        return TimeUtil.isSameMonth(time, TimeUtil.now());
    }

    public static boolean isThisMonth(long time, int sheduledClock) {
        return TimeUtil.isSameMonth(time, TimeUtil.now() - (long)sheduledClock * 3600000L);
    }

    public static String format(Date d) {
        if (d == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    public static String format(Date d, String formatter) {
        if (d == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formatter);
        return sdf.format(d);
    }

    public static int scheduledAtHour(int nowClock, int delay, int clockBeforeDelay) {
        if (nowClock < clockBeforeDelay) {
            return clockBeforeDelay;
        }
        if ((nowClock - clockBeforeDelay) % delay == 0) {
            return nowClock + delay;
        }
        return nowClock - nowClock % delay + clockBeforeDelay % delay;
    }

    public static long addTime(int seconds) {
        long now = System.currentTimeMillis();
        Calendar ca = Calendar.getInstance();
        ca.setTimeInMillis(now);
        ca.add(13, seconds);
        return ca.getTimeInMillis();
    }

    public static int getHour() {
        Calendar c = Calendar.getInstance();
        return c.get(11);
    }

    public static boolean isAfaterTheSameDayOfHour(long time, int hour) {
        boolean isSameDay = TimeUtil.isSameDay(time, TimeUtil.now());
        if (!isSameDay) {
            int daysBetween = (int)((System.currentTimeMillis() - time) / 86400000L);
            if (daysBetween >= 1) {
                return true;
            }
            int cuhour = TimeUtil.getHour();
            if (cuhour >= hour) {
                return true;
            }
        }
        return false;
    }

    public static Date getDate(long v) {
        try {
            return new Date(v);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    public static Date getDate(String timeStr) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.parse(timeStr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long nowForCache() {
        long now = System.currentTimeMillis();
        return now / 10000L * 10000L;
    }

    public static Date dateForCache() {
        long now = TimeUtil.nowForCache();
        return new Date(now);
    }

    public static Object parseDateForJson(Object v) {
        if (Objects.isNull(v)) {
            return v;
        }
        String str = v.toString();
        if ((str = str.trim()).startsWith("$date")) {
            String[] arr = str.split("=");
            String time = arr[1];
            time = time.trim();
            return new Date(Long.parseLong(time));
        }
        return v;
    }

    public static long year(Date date) {
        if (date == null) {
            return Calendar.getInstance().get(1);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static long month(Date date) {
        if (date == null) {
            return Calendar.getInstance().get(2);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2) + 1;
    }

    public static long day(Date date) {
        if (date == null) {
            return Calendar.getInstance().get(5);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static long hour(Date date) {
        if (date == null) {
            return Calendar.getInstance().get(11);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(11);
    }

    public static long minute(Date date) {
        if (date == null) {
            return Calendar.getInstance().get(12);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(12);
    }

    public static long weekFrom2000(Date date) {
        long time = date.getTime();
        long t000 = 946656000450L;
        long CLOCK_0 = TimeUtil.CLOCK_0(time);
        return (CLOCK_0 - t000) / 604800000L;
    }

    public static long week_0(Date date) {
        long time = date.getTime();
        return TimeUtil.week_0(time);
    }

    public static long week_0(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        int dayWeek = c.get(7);
        c.setTimeInMillis(time -= (long)dayWeek * 86400000L);
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }
}

