/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.commons.http;

import io.yawp.commons.http.HttpResponse;
import io.yawp.commons.utils.Environment;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public class ExceptionResponse
extends HttpResponse {
    private int httpStatus;
    private String text;

    public ExceptionResponse(int httpStatus, String text) {
        this.httpStatus = httpStatus;
        this.text = text;
    }

    public ExceptionResponse(int httpStatus) {
        this(httpStatus, null);
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void execute(HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json;charset=UTF-8");
        resp.setCharacterEncoding("UTF-8");
        resp.setStatus(this.httpStatus);
        String json = this.getJson();
        if (json == null) {
            return;
        }
        resp.getWriter().write(json);
    }

    private String getJson() {
        if (this.httpStatus == 404 && Environment.isProduction()) {
            return "{}";
        }
        return this.text;
    }
}

