/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.commons.http;

import com.google.gson.JsonElement;
import io.yawp.commons.http.ExceptionResponse;
import io.yawp.commons.http.HttpResponse;

public class HttpException
extends RuntimeException {
    private static final long serialVersionUID = -1369195874459839005L;
    private int httpStatus;
    private String text;

    public HttpException(int httpStatus, String text) {
        this.httpStatus = httpStatus;
        this.text = text;
    }

    public HttpException(int httpStatus) {
        this(httpStatus, (String)null);
    }

    public HttpException(int httpStatus, JsonElement json) {
        this(httpStatus, json.toString());
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getText() {
        return this.text;
    }

    public HttpResponse createResponse() {
        return new ExceptionResponse(this.getHttpStatus(), this.getText());
    }

    @Override
    public String toString() {
        return "<HttpException status:" + this.httpStatus + (this.text == null ? "" : " text:'" + this.text + "'") + ">";
    }
}

