/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.commons.http;

import io.yawp.commons.http.annotation.DELETE;
import io.yawp.commons.http.annotation.GET;
import io.yawp.commons.http.annotation.PATCH;
import io.yawp.commons.http.annotation.POST;
import io.yawp.commons.http.annotation.PUT;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public enum HttpVerb {
    GET(GET.class),
    POST(POST.class),
    PUT(PUT.class),
    PATCH(PATCH.class),
    DELETE(DELETE.class),
    OPTIONS;

    private Class<? extends Annotation> annotationClazz;

    private HttpVerb() {
    }

    private HttpVerb(Class<? extends Annotation> annotation) {
        this.annotationClazz = annotation;
    }

    public static HttpVerb fromString(String method) {
        String methodLowerCase = method.toUpperCase();
        return HttpVerb.valueOf(methodLowerCase);
    }

    public boolean hasAnnotation(Method method) {
        if (this.annotationClazz == null) {
            return false;
        }
        return method.isAnnotationPresent(this.annotationClazz);
    }

    public String getAnnotationValue(Method method) {
        try {
            Annotation annotation = method.getAnnotation(this.annotationClazz);
            Method valueMethod = annotation.getClass().getMethod("value", new Class[0]);
            String value = (String)valueMethod.invoke((Object)annotation, new Object[0]);
            if (StringUtils.isEmpty((CharSequence)value)) {
                return this.useMethodNameAsActionPath(method);
            }
            return value;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private String useMethodNameAsActionPath(Method method) {
        return method.getName().replaceAll("(.)(\\p{Lu})", "$1-$2").toLowerCase();
    }
}

