/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.commons.http;

import io.yawp.commons.http.HttpVerb;
import io.yawp.commons.utils.JsonUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestContext {
    private HttpServletResponse resp;
    private HttpServletRequest req;
    protected String method;
    protected String uri;
    protected String json;
    protected Map<String, String> params;

    public RequestContext() {
    }

    public RequestContext(HttpServletRequest req, HttpServletResponse resp) {
        this.req = req;
        this.resp = resp;
        this.method = this.parseMethod();
        this.uri = this.parseUri();
        this.json = this.parseJson();
        this.params = this.parseParams();
    }

    public HttpServletRequest req() {
        return this.req;
    }

    public HttpServletResponse resp() {
        return this.resp;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpVerb getHttpVerb() {
        return HttpVerb.fromString(this.method);
    }

    public String getUri() {
        return this.uri;
    }

    public String getJson() {
        return this.json;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String getParam(String key) {
        return this.params.get(key);
    }

    private String parseMethod() {
        return this.req.getMethod();
    }

    private String parseUri() {
        return this.req.getRequestURI().substring(this.req.getServletPath().length());
    }

    private String parseJson() {
        try {
            return JsonUtils.readJson(this.req.getReader());
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private Map<String, String> parseParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration e = this.req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            map.put(name, this.req.getParameter(name));
        }
        return map;
    }
}

