/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.commons.utils;

import io.yawp.driver.api.DriverFactory;
import io.yawp.driver.api.EnvironmentDriver;
import java.io.IOException;
import java.util.Properties;

public class Environment {
    public static final String DEFAULT_DEVELOPMENT_ENVIRONMENT = "development";
    public static final String DEFAULT_TEST_ENVIRONMENT = "test";
    private static final String YAWP_ENV = "yawp.env";
    private static final String YAWP_APP_DIR = "yawp.dir";

    public static boolean isProduction() {
        if (Environment.get() != null) {
            return Environment.getOrDefault().equals("production");
        }
        return Environment.environment().isProduction();
    }

    public static boolean isDevelopment() {
        if (Environment.get() != null) {
            return Environment.getOrDefault().equals(DEFAULT_DEVELOPMENT_ENVIRONMENT);
        }
        return Environment.environment().isDevelopment();
    }

    public static boolean isTest() {
        if (Environment.get() != null) {
            return Environment.getOrDefault().equals(DEFAULT_TEST_ENVIRONMENT);
        }
        return Environment.environment().isTest();
    }

    private static EnvironmentDriver environment() {
        return DriverFactory.getDriver().environment();
    }

    public static void set(String env) {
        System.setProperty(YAWP_ENV, env);
    }

    public static void setIfEmpty(String env) {
        if (Environment.get() != null) {
            return;
        }
        Environment.set(env);
    }

    public static String get() {
        return System.getProperty(YAWP_ENV);
    }

    public static String getOrDefault() {
        String env = System.getProperty(YAWP_ENV);
        if (env != null) {
            return env;
        }
        return DEFAULT_DEVELOPMENT_ENVIRONMENT;
    }

    public static void setAppDir(String appDir) {
        System.setProperty(YAWP_APP_DIR, appDir);
    }

    public static String getAppDir() {
        return System.getProperty(YAWP_APP_DIR);
    }

    public static String version() {
        try {
            Properties properties = new Properties();
            properties.load(Environment.class.getResourceAsStream("/yawp.properties"));
            return properties.getProperty("version");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

