/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.commons.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.yawp.commons.utils.IdRefJsonAdapter;
import io.yawp.commons.utils.ParameterizedTypeImpl;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static Gson buildGson(Repository r) {
        GsonBuilder builder = new GsonBuilder();
        builder.setDateFormat("yyyy/MM/dd HH:mm:ss");
        builder.registerTypeAdapter(IdRef.class, (Object)new IdRefJsonAdapter(r));
        return builder.create();
    }

    public static Object from(Repository r, String json, Type type) {
        JsonElement jsonElement = new JsonParser().parse(json);
        Gson gson = JsonUtils.buildGson(r);
        return gson.fromJson(jsonElement, type);
    }

    public static String to(Object o) {
        Gson gson = JsonUtils.buildGson(null);
        return gson.toJson(o);
    }

    public static <T> T from(Repository r, String json, Class<T> clazz) {
        return (T)JsonUtils.from(r, json, clazz);
    }

    public static Object fromMap(String json, Type keyType, Type valueType) {
        return JsonUtils.fromMap(json, (Class)keyType, (Class)valueType);
    }

    public static <T> List<T> fromList(Repository r, String json, Class<T> clazz) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl((Type)((Object)List.class), new Type[]{clazz}, null);
        return (List)JsonUtils.from(r, json, type);
    }

    public static <K, V> Map<K, V> fromMap(Repository r, String json, Class<K> keyClazz, Class<V> valueClazz) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl((Type)((Object)Map.class), new Type[]{keyClazz, valueClazz}, null);
        return (Map)JsonUtils.from(r, json, type);
    }

    public static <K, V> Map<K, List<V>> fromMapList(Repository r, String json, Class<K> keyClazz, Class<V> valueClazz) {
        ParameterizedTypeImpl listType = new ParameterizedTypeImpl((Type)((Object)List.class), new Type[]{valueClazz}, null);
        ParameterizedTypeImpl type = new ParameterizedTypeImpl((Type)((Object)Map.class), new Type[]{keyClazz, listType}, null);
        return (Map)JsonUtils.from(r, json, type);
    }

    public static String readJson(BufferedReader reader) {
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static boolean isJsonArray(String json) {
        if (json == null) {
            return false;
        }
        JsonElement parsed = new JsonParser().parse(json);
        return parsed.isJsonArray();
    }

    public static List<String> getProperties(String json) {
        ArrayList<String> properties = new ArrayList<String>();
        JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
        for (Map.Entry property : jsonObject.entrySet()) {
            properties.add((String)property.getKey());
        }
        return properties;
    }
}

