/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.commons.utils.kind;

import io.yawp.commons.utils.kind.DefaultKindResolver;

public abstract class KindResolver {
    private static final String KINDRESOLVER_SETTING_KEY = "yawp.kindresolver";
    private static KindResolver kindResolver;

    public abstract String getKind(Class<?> var1);

    @Deprecated
    public abstract String getPath(String var1);

    private static void loadKindResolver() {
        String kindResolverClazzName = System.getProperty(KINDRESOLVER_SETTING_KEY);
        if (kindResolverClazzName == null) {
            kindResolver = new DefaultKindResolver();
            return;
        }
        try {
            kindResolver = (KindResolver)Class.forName(kindResolverClazzName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Invalid kind resolver: " + kindResolverClazzName, e);
        }
    }

    public static String getKindFromClass(Class<?> clazz) {
        return kindResolver.getKind(clazz);
    }

    static {
        KindResolver.loadKindResolver();
    }
}

