/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository;

import io.yawp.commons.utils.kind.KindResolver;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.actions.ActionMethod;
import io.yawp.repository.annotations.Endpoint;
import io.yawp.repository.hooks.Hook;
import io.yawp.repository.pipes.Pipe;
import io.yawp.repository.shields.ShieldInfo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EndpointFeatures<T> {
    private Class<T> clazz;
    private Map<ActionKey, ActionMethod> actions;
    private Map<String, Method> transformers;
    private Set<Class<? extends Hook>> hooks;
    private ShieldInfo<? super T> shieldInfo;
    private Set<Class<? extends Pipe>> pipes;
    private List<Class<? extends Pipe>> pipesSink;

    public EndpointFeatures(Class<T> clazz) {
        this.clazz = clazz;
        this.actions = new HashMap<ActionKey, ActionMethod>();
        this.transformers = new HashMap<String, Method>();
        this.hooks = new HashSet<Class<? extends Hook>>();
        this.pipes = new HashSet<Class<? extends Pipe>>();
    }

    private void assertValidPathOrKind() {
        Endpoint endpoint = this.clazz.getAnnotation(Endpoint.class);
        if (endpoint == null) {
            throw new RuntimeException("The class " + this.clazz.getName() + " was used as an entity but was not annotated with @Endpoint.");
        }
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Endpoint getEndpointAnnotation() {
        return this.clazz.getAnnotation(Endpoint.class);
    }

    public String getEndpointPath() {
        Endpoint endpoint = this.clazz.getAnnotation(Endpoint.class);
        return endpoint.path();
    }

    public String getEndpointKind() {
        return KindResolver.getKindFromClass(this.clazz);
    }

    public ActionMethod getAction(ActionKey key) {
        return this.actions.get(key);
    }

    public Class<?> getActionClazz(ActionKey key) {
        return this.actions.get(key).getMethod().getDeclaringClass();
    }

    public boolean hasCustomAction(ActionKey actionKey) {
        return this.actions.containsKey(actionKey);
    }

    public Method getTransformer(String name) {
        return this.transformers.get(name);
    }

    public boolean hasTranformer(String transformerName) {
        return this.transformers.containsKey(transformerName);
    }

    public Set<Class<? extends Hook>> getHooks() {
        return this.hooks;
    }

    public ShieldInfo<? super T> getShieldInfo() {
        return this.shieldInfo;
    }

    public Set<Class<? extends Pipe>> getPipes() {
        return this.pipes;
    }

    public List<Class<? extends Pipe>> getPipesSink() {
        return this.pipesSink;
    }

    public boolean hasShield() {
        return this.shieldInfo != null;
    }

    public void setActions(Map<ActionKey, ActionMethod> actions) {
        this.actions = actions;
    }

    public void setTransformers(Map<String, Method> transformers) {
        this.transformers = transformers;
    }

    public void setHooks(Set<Class<? extends Hook>> hooks) {
        this.hooks = hooks;
    }

    public void setShieldInfo(ShieldInfo<? super T> shieldInfo) {
        this.shieldInfo = shieldInfo;
    }

    public void setPipes(Set<Class<? extends Pipe>> pipes) {
        this.pipes = pipes;
    }

    public void setPipesSink(List<Class<? extends Pipe>> pipesSink) {
        this.pipesSink = pipesSink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointFeatures that = (EndpointFeatures)o;
        return this.clazz.equals(that.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }
}

