/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository;

import io.yawp.commons.http.RequestContext;
import io.yawp.commons.utils.JsonUtils;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.query.QueryBuilder;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class Feature {
    protected Repository yawp;
    protected RequestContext requestContext;

    public void setRepository(Repository yawp) {
        this.yawp = yawp;
        this.requestContext = yawp.getRequestContext();
    }

    public <T> QueryBuilder<T> yawp(Class<T> clazz) {
        return this.yawp.query(clazz);
    }

    public <T> QueryBuilder<T> yawpWithHooks(Class<T> clazz) {
        return this.yawp.queryWithHooks(clazz);
    }

    public boolean isOnRequest() {
        return this.requestContext != null;
    }

    public <T extends Feature> T feature(Class<T> clazz) {
        try {
            Feature feature = (Feature)clazz.newInstance();
            feature.setRepository(this.yawp);
            return (T)feature;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> IdRef<T> id(Class<T> clazz, Long id) {
        return IdRef.create(this.yawp, clazz, id);
    }

    public <T> IdRef<T> id(Class<T> clazz, String name) {
        return IdRef.create(this.yawp, clazz, name);
    }

    public <T> T from(String json, Class<T> clazz) {
        return JsonUtils.from(this.yawp, json, clazz);
    }

    public <T> List<T> fromList(String json, Class<T> clazz) {
        return JsonUtils.fromList(this.yawp, json, clazz);
    }

    public String to(Object object) {
        return JsonUtils.to(object);
    }

    protected Map<String, Object> asMap(Object object) {
        try {
            Map map = PropertyUtils.describe((Object)object);
            map.remove("class");
            return map;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

