/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository;

import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.hooks.RepositoryHooks;
import io.yawp.repository.models.ObjectHolder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FutureObject<T> {
    private Repository r;
    private Future<IdRef<?>> futureIdRef;
    private T object;
    private boolean enableHooks;

    public FutureObject(Repository r, Future<IdRef<?>> futureIdRef, T object) {
        this.r = r;
        this.futureIdRef = futureIdRef;
        this.object = object;
    }

    public void setEnableHooks(boolean enableHooks) {
        this.enableHooks = enableHooks;
    }

    public T get() {
        try {
            this.setObjectId();
            if (this.enableHooks) {
                RepositoryHooks.afterSave(this.r, this.object);
            }
            return this.object;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void setObjectId() throws InterruptedException, ExecutionException {
        ObjectHolder objectHolder = new ObjectHolder(this.object);
        objectHolder.setId(this.futureIdRef.get());
    }
}

