/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository;

import io.yawp.commons.http.HttpVerb;
import io.yawp.repository.Repository;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.models.ObjectModel;
import io.yawp.repository.query.QueryBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class IdRef<T>
implements Comparable<IdRef<T>> {
    private Repository r;
    private Class<T> clazz;
    private ObjectModel model;
    private Long id;
    private String name;
    private IdRef<?> parentId;
    private boolean shuffled;

    protected IdRef(Repository r, Class<T> clazz, Long id) {
        this.r = r;
        this.clazz = clazz;
        this.id = id;
        this.model = new ObjectModel(clazz);
    }

    public IdRef(Repository r, Class<T> clazz, String name) {
        this.r = r;
        this.clazz = clazz;
        this.name = name;
        this.model = new ObjectModel(clazz);
    }

    public void setParentId(IdRef<?> parentId) {
        this.parentId = parentId;
    }

    public T fetch() {
        return this.fetch(this.clazz);
    }

    public <TT> TT fetch(Class<TT> childClazz) {
        return this.r.query(childClazz).fetch(this);
    }

    public <TT> TT child(Class<TT> childClazz) {
        QueryBuilder<TT> q = this.r.query(childClazz).from(this);
        return q.only();
    }

    public Long asLong() {
        return this.id;
    }

    public String asString() {
        return this.name;
    }

    public Repository getRepository() {
        return this.r;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Class<?> getParentClazz() {
        return this.model.getParentClazz();
    }

    public ObjectModel getModel() {
        return new ObjectModel(this.clazz);
    }

    public <TT> IdRef<TT> getParentId() {
        return this.parentId;
    }

    public <TT> IdRef<TT> getAncestorId(int ancestor) {
        IdRef<TT> ancestorId = this;
        for (int i = 0; i <= ancestor; ++i) {
            ancestorId = ancestorId.getParentId();
        }
        return ancestorId;
    }

    public <TT> IdRef<TT> createChildId(Class<TT> clazz, Long id) {
        IdRef<TT> idRef = new IdRef<TT>(this.r, clazz, id);
        idRef.setParentId(this);
        return idRef;
    }

    public <TT> IdRef<TT> createChildId(Class<TT> clazz, String name) {
        IdRef<TT> idRef = new IdRef<TT>(this.r, clazz, name);
        idRef.setParentId(this);
        return idRef;
    }

    public static <TT> IdRef<TT> create(Repository r, Class<TT> clazz, Long id) {
        return new IdRef<TT>(r, clazz, id);
    }

    public static <TT> IdRef<TT> create(Repository r, Class<TT> clazz, String name) {
        return new IdRef<TT>(r, clazz, name);
    }

    public static <TT> List<IdRef<TT>> create(Repository r, Class<TT> clazz, Long ... ids) {
        ArrayList<IdRef<TT>> idRefs = new ArrayList<IdRef<TT>>();
        for (int i = 0; i < ids.length; ++i) {
            idRefs.add(IdRef.create(r, clazz, ids[i]));
        }
        return idRefs;
    }

    public static <TT> IdRef<TT> parse(Repository r, HttpVerb verb, String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        String[] parts = path.substring(1).split("/");
        if (parts.length < 2) {
            return null;
        }
        IdRef<?> lastIdRef = null;
        for (int i = 0; i < parts.length && !IdRef.isActionOrCollection(r, verb, parts, i); i += 2) {
            String endpointPath = "/" + parts[i];
            IdRef<?> currentIdRef = null;
            if (!IdRef.isString(parts[i + 1])) {
                Long asLong = Long.valueOf(parts[i + 1]);
                currentIdRef = IdRef.create(r, IdRef.getIdRefClazz(r, endpointPath), asLong);
            } else {
                String asString = parts[i + 1];
                currentIdRef = IdRef.create(r, IdRef.getIdRefClazz(r, endpointPath), asString);
            }
            currentIdRef.setParentId(lastIdRef);
            lastIdRef = currentIdRef;
            IdRef.validateParentId(currentIdRef, path);
        }
        return lastIdRef;
    }

    public static IdRef<?> parse(Repository r, String id) {
        return IdRef.parse(r, HttpVerb.GET, id);
    }

    public static <T> IdRef<T> parse(Class<T> clazz, Repository r, String idString) {
        return IdRef.parse(r, HttpVerb.GET, idString);
    }

    public static <T> List<IdRef<T>> parse(Class<T> clazz, Repository r, List<String> idsString) {
        ArrayList<IdRef<T>> ids = new ArrayList<IdRef<T>>();
        for (String idString : idsString) {
            ids.add(IdRef.parse(clazz, r, idString));
        }
        return ids;
    }

    private static void validateParentId(IdRef<?> id, String path) {
        Class<?> parentClazz = id.getParentClazz();
        if (parentClazz == null) {
            return;
        }
        if (id.getParentId() == null) {
            throw new RuntimeException("Invalid parent structure for id: " + path);
        }
        if (!parentClazz.equals(id.getParentId().getClazz())) {
            throw new RuntimeException("Invalid parent structure for id: " + path);
        }
    }

    private static Class<?> getIdRefClazz(Repository r, String endpointPath) {
        return r.getFeatures().getByPath(endpointPath).getClazz();
    }

    private static boolean isActionOrCollection(Repository r, HttpVerb verb, String[] parts, int i) {
        if (i < parts.length - 2) {
            return false;
        }
        if (i == parts.length - 1) {
            return true;
        }
        if (!IdRef.isString(parts[parts.length - 1])) {
            return false;
        }
        String endpointPath = "/" + parts[parts.length - 2];
        String possibleAction = parts[parts.length - 1];
        ActionKey actionKey = new ActionKey(verb, possibleAction, true);
        return r.getFeatures().hasCustomAction(endpointPath, actionKey);
    }

    private static boolean isString(String s) {
        try {
            Long.valueOf(s);
            return false;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public void delete() {
        this.r.destroy(this);
    }

    public Object getSimpleValue() {
        if (this.id != null) {
            return this.id;
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Long getId() {
        return this.id;
    }

    public boolean isShuffled() {
        return this.model.isIdShuffled();
    }

    public boolean isAncestorId(IdRef<?> childId) {
        IdRef<Object> currentId = childId;
        while (currentId.getParentId() != null) {
            if (currentId.getParentId().getClazz().equals(this.getClazz())) {
                return this.equals(currentId.getParentId());
            }
            currentId = currentId.getParentId();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parentId == null ? 0 : this.parentId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdRef other = (IdRef)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parentId == null ? other.parentId != null : !this.parentId.equals(other.parentId));
    }

    @Override
    public int compareTo(IdRef<T> o) {
        if (this.id != null && o.id != null) {
            return this.id.compareTo(o.id);
        }
        return this.idOrNameAsString().compareTo(super.idOrNameAsString());
    }

    private String idOrNameAsString() {
        return this.id != null ? String.valueOf(this.id) : this.name;
    }

    public String toString() {
        return this.getUri();
    }

    public String getUri() {
        StringBuilder sb = new StringBuilder();
        if (this.parentId != null) {
            sb.append(this.parentId.toString());
        }
        sb.append(this.r.getFeatures().getByClazz(this.clazz).getEndpointPath());
        sb.append("/");
        sb.append(this.id != null ? this.id : this.name);
        return sb.toString();
    }
}

