/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository;

import io.yawp.commons.http.RequestContext;
import io.yawp.driver.api.Driver;
import io.yawp.driver.api.DriverFactory;
import io.yawp.driver.api.TransactionDriver;
import io.yawp.repository.AsyncRepository;
import io.yawp.repository.EndpointFeatures;
import io.yawp.repository.FutureObject;
import io.yawp.repository.IdRef;
import io.yawp.repository.Namespace;
import io.yawp.repository.RepositoryApi;
import io.yawp.repository.RepositoryFeatures;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.actions.ActionMethod;
import io.yawp.repository.actions.RepositoryActions;
import io.yawp.repository.hooks.RepositoryHooks;
import io.yawp.repository.pipes.RepositoryPipes;
import io.yawp.repository.query.QueryBuilder;
import java.util.List;
import java.util.Map;

public class Repository
implements RepositoryApi {
    private RepositoryFeatures repositoryFeatures;
    private RequestContext requestContext;
    private Namespace namespace;
    private Driver driver;
    private TransactionDriver tx;

    public static Repository r() {
        return new Repository();
    }

    public static Repository r(String ns) {
        return new Repository(ns);
    }

    private Repository() {
        this.namespace = new Namespace(this.driver().namespace());
    }

    private Repository(String ns) {
        this.namespace = new Namespace(ns, this.driver().namespace());
    }

    @Override
    public Repository namespace(String ns) {
        this.namespace.setNs(ns);
        return this;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    @Override
    public String currentNamespace() {
        return this.namespace.getNs();
    }

    @Override
    public Repository setFeatures(RepositoryFeatures repositoryFeatures) {
        this.repositoryFeatures = repositoryFeatures;
        return this;
    }

    @Override
    public Repository setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    @Override
    public Driver driver() {
        if (this.driver != null) {
            return this.driver;
        }
        this.driver = DriverFactory.getDriver(this);
        return this.driver;
    }

    @Override
    public AsyncRepository async() {
        return new AsyncRepository(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T saveWithHooks(T object) {
        this.namespace.set(object.getClass());
        try {
            RepositoryHooks.beforeSave(this, object);
            this.saveInternal(object);
            RepositoryHooks.afterSave(this, object);
        }
        finally {
            this.namespace.reset();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T save(T object) {
        this.namespace.set(object.getClass());
        try {
            this.saveInternal(object);
        }
        finally {
            this.namespace.reset();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> FutureObject<T> saveAsyncWithHooks(T object) {
        this.namespace.set(object.getClass());
        try {
            FutureObject<T> future;
            RepositoryHooks.beforeSave(this, object);
            FutureObject<T> futureObject = future = this.saveInternalAsync(object, true);
            return futureObject;
        }
        finally {
            this.namespace.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> FutureObject<T> saveAsync(T object) {
        this.namespace.set(object.getClass());
        try {
            FutureObject<T> future;
            FutureObject<T> futureObject = future = this.saveInternalAsync(object, false);
            return futureObject;
        }
        finally {
            this.namespace.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInternal(Object object) {
        boolean newTransaction = this.beginTransactionForPipesOnSave(object);
        try {
            this.updateExistingPipes(object);
            this.driver().persistence().save(object);
            this.fluxPipes(object);
            if (newTransaction) {
                this.commit();
            }
        }
        finally {
            if (newTransaction && this.isTransationInProgress()) {
                this.rollback();
            }
        }
    }

    private boolean beginTransactionForPipesOnSave(Object object) {
        Class<?> endpointClazz = object.getClass();
        if (!RepositoryPipes.isPipeSourceOrSink(this, endpointClazz)) {
            return false;
        }
        return this.beginTransactionForPipes(endpointClazz);
    }

    private boolean beginTransactionForPipesOnDestroy(IdRef<?> id) {
        Class<?> endpointClazz = id.getClazz();
        if (!RepositoryPipes.isPipeSource(this, endpointClazz)) {
            return false;
        }
        return this.beginTransactionForPipes(endpointClazz);
    }

    private boolean beginTransactionForPipes(Class<?> endpointClazz) {
        if (this.isTransationInProgress()) {
            return false;
        }
        this.begin();
        return true;
    }

    private void fluxPipes(Object object) {
        RepositoryPipes.flux(this, object);
    }

    private void refluxPipes(IdRef<?> id) {
        RepositoryPipes.reflux(this, id);
    }

    private void updateExistingPipes(Object object) {
        RepositoryPipes.updateExisting(this, object);
    }

    private <T> FutureObject<T> saveInternalAsync(T object, boolean enableHooks) {
        FutureObject futureObject = this.driver().persistence().saveAsync(object);
        futureObject.setEnableHooks(enableHooks);
        return futureObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object action(IdRef<?> id, Class<?> clazz, ActionKey actionKey, String json, Map<String, String> params) {
        this.namespace.set(clazz);
        try {
            ActionMethod actionMethod = this.repositoryFeatures.getByClazz(clazz).getAction(actionKey);
            Object object = RepositoryActions.execute(this, actionMethod, id, json, params);
            return object;
        }
        finally {
            this.namespace.reset();
        }
    }

    @Override
    public <T> QueryBuilder<T> queryWithHooks(Class<T> clazz) {
        QueryBuilder<T> q = QueryBuilder.q(clazz, this);
        RepositoryHooks.beforeQuery(this, q, clazz);
        return q;
    }

    @Override
    public <T> QueryBuilder<T> query(Class<T> clazz) {
        return QueryBuilder.q(clazz, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(IdRef<?> id) {
        this.namespace.set(id.getClazz());
        try {
            RepositoryHooks.beforeDestroy(this, id);
            this.destroyInternal(id);
            RepositoryHooks.afterDestroy(this, id);
        }
        finally {
            this.namespace.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInternal(IdRef<?> id) {
        boolean newTransaction = this.beginTransactionForPipesOnDestroy(id);
        try {
            this.refluxPipes(id);
            this.driver().persistence().destroy(id);
            if (newTransaction) {
                this.commit();
            }
        }
        finally {
            if (newTransaction && this.isTransationInProgress()) {
                this.rollback();
            }
        }
    }

    @Override
    public Class<?> getClazzByKind(String kind) {
        return this.repositoryFeatures.getClazzByKind(kind);
    }

    @Override
    public <T> EndpointFeatures<T> getEndpointFeatures(Class<T> endpoint) {
        return this.repositoryFeatures.getByClazz(endpoint);
    }

    @Override
    public EndpointFeatures<?> getEndpointFeatures(String endpointPath) {
        return this.repositoryFeatures.getByPath(endpointPath);
    }

    @Override
    public RepositoryFeatures getFeatures() {
        return this.repositoryFeatures;
    }

    @Override
    public <T> IdRef<T> parseId(Class<T> clazz, String idString) {
        return IdRef.parse(clazz, this, idString);
    }

    @Override
    public <T> List<IdRef<T>> parseIds(Class<T> clazz, List<String> idsString) {
        return IdRef.parse(clazz, this, idsString);
    }

    @Override
    public void begin() {
        this.tx = this.driver().transaction().begin();
    }

    @Override
    public void beginX() {
        this.tx = this.driver().transaction().beginX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        if (this.tx == null) {
            throw new RuntimeException("No transaction in progress");
        }
        try {
            this.tx.rollback();
        }
        finally {
            this.tx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (this.tx == null) {
            throw new RuntimeException("No transaction in progress");
        }
        try {
            this.tx.commit();
        }
        finally {
            this.tx = null;
        }
    }

    @Override
    public boolean isTransationInProgress() {
        return this.tx != null;
    }

    @Override
    public TransactionDriver currentTransaction() {
        return this.tx;
    }

    @Override
    public RequestContext getRequestContext() {
        return this.requestContext;
    }
}

