/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository;

import io.yawp.repository.EndpointFeatures;
import io.yawp.repository.EndpointNotFoundException;
import io.yawp.repository.actions.ActionKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RepositoryFeatures {
    private Map<Class<?>, EndpointFeatures<?>> endpoints;
    private Map<String, Class<?>> paths;
    private Map<String, Class<?>> kinds;

    protected RepositoryFeatures() {
    }

    public RepositoryFeatures(Map<Class<?>, EndpointFeatures<?>> endpoints) {
        this.endpoints = endpoints;
        this.paths = new HashMap();
        this.kinds = new HashMap();
        this.initAndLoadPaths();
    }

    private void initAndLoadPaths() {
        for (EndpointFeatures<?> endpoint : this.endpoints.values()) {
            this.addKindToMap(endpoint);
            this.addMapPathKind(endpoint);
        }
    }

    private void addKindToMap(EndpointFeatures<?> endpoint) {
        String kind = endpoint.getEndpointKind();
        this.kinds.put(kind, endpoint.getClazz());
    }

    private void addMapPathKind(EndpointFeatures<?> endpoint) {
        String endpointPath = endpoint.getEndpointPath();
        if (endpointPath.isEmpty()) {
            return;
        }
        this.assertIsValidPath(endpoint, endpointPath);
        this.paths.put(endpointPath, endpoint.getClazz());
    }

    private void assertIsValidPath(EndpointFeatures<?> endpoint, String endpointPath) {
        if (this.paths.get(endpointPath) != null) {
            throw new RuntimeException("Repeated io.yawp path " + endpointPath + " for class " + endpoint.getClazz().getSimpleName() + " (already found in class " + this.paths.get(endpointPath).getSimpleName() + ")");
        }
        if (!this.isValidEndpointPath(endpointPath)) {
            throw new RuntimeException("Invalid endpoint path " + endpointPath + " for class " + endpoint.getClazz().getSimpleName());
        }
    }

    protected boolean isValidEndpointPath(String endpointName) {
        char[] charArray = endpointName.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (!(i == 0 ? c != '/' : !Character.isAlphabetic(c) && c != '_' && c != '-')) continue;
            return false;
        }
        return true;
    }

    public EndpointFeatures<?> getByClazz(Class<?> clazz) {
        return this.endpoints.get(clazz);
    }

    public EndpointFeatures<?> getByPath(String endpointPath) {
        Class<?> clazz = this.paths.get(endpointPath);
        if (clazz == null) {
            throw new EndpointNotFoundException(endpointPath);
        }
        return this.getByClazz(clazz);
    }

    public Class<?> getClazzByKind(String kind) {
        return this.kinds.get(kind);
    }

    public boolean hasCustomAction(String endpointPath, ActionKey actionKey) {
        EndpointFeatures<?> endpointFeatures = this.getByPath(endpointPath);
        return endpointFeatures.hasCustomAction(actionKey);
    }

    public boolean hasCustomAction(Class<?> clazz, ActionKey actionKey) {
        EndpointFeatures<?> endpointFeatures = this.getByClazz(clazz);
        return endpointFeatures.hasCustomAction(actionKey);
    }

    public Set<Class<?>> getEndpointClazzes() {
        return this.endpoints.keySet();
    }
}

