/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository;

import io.yawp.commons.config.Config;
import io.yawp.commons.config.FeaturesConfig;
import io.yawp.commons.http.RequestContext;
import io.yawp.driver.api.Driver;
import io.yawp.driver.api.TransactionDriver;
import io.yawp.repository.AsyncRepository;
import io.yawp.repository.EndpointFeatures;
import io.yawp.repository.Feature;
import io.yawp.repository.IdRef;
import io.yawp.repository.Namespace;
import io.yawp.repository.Repository;
import io.yawp.repository.RepositoryApi;
import io.yawp.repository.RepositoryFeatures;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.query.QueryBuilder;
import io.yawp.repository.scanner.RepositoryScanner;
import java.util.List;
import java.util.Map;

public class Yawp
extends ThreadLocal<Repository>
implements RepositoryApi {
    public static Yawp yawp = new Yawp();
    private static RepositoryFeatures features;

    public static <T> QueryBuilder<T> yawp(Class<T> clazz) {
        Yawp.init();
        return ((Repository)yawp.get()).query(clazz);
    }

    public static Repository yawp() {
        Yawp.init();
        return (Repository)yawp.get();
    }

    public static void destroyFeatures() {
        features = null;
    }

    public static void dispose() {
        yawp.set(null);
    }

    public static <T extends Feature> T feature(Class<T> clazz) {
        try {
            Feature feature = (Feature)clazz.newInstance();
            feature.setRepository(Yawp.yawp());
            return (T)feature;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void init() {
        if (yawp.get() != null) {
            return;
        }
        if (features == null) {
            Yawp.safeLoadFeaturesFromConfig();
        }
        yawp.set(Repository.r().setFeatures(features));
    }

    public static void init(String packagePrefix) {
        if (yawp.get() != null) {
            return;
        }
        if (features == null) {
            Yawp.safeLoadFeatures(packagePrefix);
        }
        yawp.set(Repository.r().setFeatures(features));
    }

    private static synchronized void safeLoadFeaturesFromConfig() {
        if (features != null) {
            return;
        }
        Config config = Config.load();
        FeaturesConfig featuresConfig = config.getDefaultFeatures();
        Yawp.safeLoadFeatures(featuresConfig.getPackagePrefix());
    }

    private static synchronized void safeLoadFeatures(String packagePrefix) {
        if (features != null) {
            return;
        }
        RepositoryScanner scanner = new RepositoryScanner(packagePrefix);
        scanner.enableHooks(true);
        features = scanner.scan();
    }

    @Override
    public Repository namespace(String ns) {
        Yawp.init();
        return ((Repository)this.get()).namespace(ns);
    }

    @Override
    public Namespace namespace() {
        Yawp.init();
        return ((Repository)this.get()).namespace();
    }

    @Override
    public String currentNamespace() {
        Yawp.init();
        return ((Repository)this.get()).currentNamespace();
    }

    @Override
    public Repository setFeatures(RepositoryFeatures repositoryFeatures) {
        Yawp.init();
        return ((Repository)this.get()).setFeatures(repositoryFeatures);
    }

    @Override
    public Repository setRequestContext(RequestContext requestContext) {
        Yawp.init();
        return ((Repository)this.get()).setRequestContext(requestContext);
    }

    @Override
    public Driver driver() {
        Yawp.init();
        return ((Repository)this.get()).driver();
    }

    @Override
    public AsyncRepository async() {
        Yawp.init();
        return ((Repository)this.get()).async();
    }

    @Override
    public <T> T saveWithHooks(T object) {
        Yawp.init();
        return ((Repository)this.get()).saveWithHooks(object);
    }

    @Override
    public <T> T save(T object) {
        Yawp.init();
        return ((Repository)this.get()).save(object);
    }

    @Override
    public Object action(IdRef<?> id, Class<?> clazz, ActionKey actionKey, String json, Map<String, String> params) {
        Yawp.init();
        return ((Repository)this.get()).action(id, clazz, actionKey, json, params);
    }

    @Override
    public <T> QueryBuilder<T> queryWithHooks(Class<T> clazz) {
        Yawp.init();
        return ((Repository)this.get()).queryWithHooks(clazz);
    }

    @Override
    public <T> QueryBuilder<T> query(Class<T> clazz) {
        Yawp.init();
        return ((Repository)this.get()).query(clazz);
    }

    @Override
    public void destroy(IdRef<?> id) {
        Yawp.init();
        ((Repository)this.get()).destroy(id);
    }

    @Override
    public Class<?> getClazzByKind(String kind) {
        Yawp.init();
        return ((Repository)this.get()).getClazzByKind(kind);
    }

    @Override
    public <T> EndpointFeatures<T> getEndpointFeatures(Class<T> endpoint) {
        Yawp.init();
        return ((Repository)this.get()).getEndpointFeatures(endpoint);
    }

    @Override
    public EndpointFeatures<?> getEndpointFeatures(String endpointPath) {
        Yawp.init();
        return ((Repository)this.get()).getEndpointFeatures(endpointPath);
    }

    @Override
    public RepositoryFeatures getFeatures() {
        Yawp.init();
        return ((Repository)this.get()).getFeatures();
    }

    @Override
    public <T> IdRef<T> parseId(Class<T> clazz, String idString) {
        Yawp.init();
        return ((Repository)this.get()).parseId(clazz, idString);
    }

    @Override
    public <T> List<IdRef<T>> parseIds(Class<T> clazz, List<String> idsString) {
        Yawp.init();
        return ((Repository)this.get()).parseIds(clazz, idsString);
    }

    @Override
    public void begin() {
        Yawp.init();
        ((Repository)this.get()).begin();
    }

    @Override
    public void beginX() {
        Yawp.init();
        ((Repository)this.get()).beginX();
    }

    @Override
    public void rollback() {
        Yawp.init();
        ((Repository)this.get()).rollback();
    }

    @Override
    public void commit() {
        Yawp.init();
        ((Repository)this.get()).commit();
    }

    @Override
    public boolean isTransationInProgress() {
        Yawp.init();
        return ((Repository)this.get()).isTransationInProgress();
    }

    @Override
    public TransactionDriver currentTransaction() {
        Yawp.init();
        return ((Repository)this.get()).currentTransaction();
    }

    @Override
    public RequestContext getRequestContext() {
        Yawp.init();
        return ((Repository)this.get()).getRequestContext();
    }
}

