/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.actions;

import io.yawp.commons.http.HttpVerb;
import io.yawp.commons.utils.ThrownExceptionsUtils;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.actions.Action;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.actions.ActionParameters;
import io.yawp.repository.actions.Atomic;
import io.yawp.repository.actions.InvalidActionMethodException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActionMethod {
    private Method method;
    private ActionParameters parameters;
    private final List<ActionKey> actionKeys;

    public ActionMethod(Method method) throws InvalidActionMethodException {
        this.method = method;
        this.parameters = new ActionParameters(method);
        this.actionKeys = this.parseActionKeys();
    }

    public List<ActionKey> getActionKeys() {
        return this.actionKeys;
    }

    public static boolean isAction(Method method) {
        for (HttpVerb verb : HttpVerb.values()) {
            if (!verb.hasAnnotation(method)) continue;
            return true;
        }
        return false;
    }

    public static List<ActionKey> getActionKeysFor(Method method) throws InvalidActionMethodException {
        ActionMethod actionMethod = new ActionMethod(method);
        return actionMethod.getActionKeys();
    }

    public Method getMethod() {
        return this.method;
    }

    private List<ActionKey> parseActionKeys() {
        ArrayList<ActionKey> actionKeys = new ArrayList<ActionKey>();
        for (HttpVerb verb : HttpVerb.values()) {
            if (!this.hasAnnotationFor(verb)) continue;
            String value = verb.getAnnotationValue(this.method);
            actionKeys.add(new ActionKey(verb, value, this.parameters.isOverCollection()));
        }
        return actionKeys;
    }

    private boolean hasAnnotationFor(HttpVerb verb) {
        return verb.hasAnnotation(this.method);
    }

    public Object[] createArguments(Repository r, IdRef<?> id, String json, Map<String, String> params) {
        return this.parameters.createArguments(r, id, json, params);
    }

    public boolean isAtomicCrossEntities() {
        return this.method.getAnnotation(Atomic.class).cross();
    }

    public boolean isAtomic() {
        return this.method.isAnnotationPresent(Atomic.class);
    }

    public Object invoke(Repository r, IdRef<?> id, String json, Map<String, String> params) {
        try {
            Class<?> actionClazz = this.method.getDeclaringClass();
            Action actionInstance = (Action)actionClazz.newInstance();
            actionInstance.setRepository(r);
            return this.method.invoke((Object)actionInstance, this.createArguments(r, id, json, params));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw ThrownExceptionsUtils.handle(e);
        }
    }
}

