/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.actions;

import io.yawp.commons.utils.JsonUtils;
import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.actions.InvalidActionMethodException;
import io.yawp.repository.models.ObjectModel;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionParameters {
    private Method method;
    private Class<?> endpointClazz;
    private List<ParameterType> order = new ArrayList<ParameterType>();
    private Map<ParameterType, Integer> count = new HashMap<ParameterType, Integer>();
    private Class<?> jsonClazz;
    private Type jsonGenericType;

    public ActionParameters(Method method) throws InvalidActionMethodException {
        this.method = method;
        this.setEndpointClazz(method);
        this.init();
        if (!this.isValid()) {
            throw new InvalidActionMethodException();
        }
    }

    private void setEndpointClazz(Method method) {
        this.endpointClazz = ReflectionUtils.getFeatureEndpointClazz(method.getDeclaringClass());
    }

    public int size() {
        return this.order.size();
    }

    public boolean isValid() {
        return this.isRootCollection() || this.isSingleObject() || this.isParentCollection();
    }

    public boolean isOverCollection() {
        if (this.size() == 0) {
            return true;
        }
        if (this.size() == 1) {
            return this.count(ParameterType.PARENT_ID) == 1 || this.count(ParameterType.JSON) == 1 || this.count(ParameterType.PARAMS) == 1;
        }
        if (this.size() == 2) {
            if (this.count(ParameterType.PARENT_ID) == 1) {
                return this.count(ParameterType.JSON) == 1 || this.count(ParameterType.PARAMS) == 1;
            }
            if (this.count(ParameterType.JSON) == 1) {
                return this.count(ParameterType.PARENT_ID) == 1 || this.count(ParameterType.PARAMS) == 1;
            }
            if (this.count(ParameterType.PARAMS) == 1) {
                return this.count(ParameterType.PARENT_ID) == 1 || this.count(ParameterType.JSON) == 1;
            }
        }
        if (this.size() == 3) {
            return this.count(ParameterType.PARENT_ID) == 1 && this.count(ParameterType.PARAMS) == 1 && this.count(ParameterType.JSON) == 1;
        }
        return false;
    }

    public Object[] createArguments(Repository r, IdRef<?> id, String json, Map<String, String> params) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (ParameterType type : this.order) {
            switch (type) {
                case ID: 
                case PARENT_ID: {
                    arguments.add(id);
                    break;
                }
                case JSON: {
                    arguments.add(this.getJsonArgument(r, json));
                    break;
                }
                case PARAMS: {
                    arguments.add(params);
                }
            }
        }
        return arguments.toArray();
    }

    private void init() throws InvalidActionMethodException {
        Class<?>[] parameters = this.method.getParameterTypes();
        Type[] genericParameterTypes = this.method.getGenericParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            ParameterInfo parameterInfo = new ParameterInfo(parameters[i], genericParameterTypes[i]);
            ParameterType type = parameterInfo.getType();
            this.order.add(type);
            this.incrementCount(type);
            if (type != ParameterType.JSON) continue;
            this.defineJsonClazz(parameterInfo);
        }
    }

    private void defineJsonClazz(ParameterInfo parameterInfo) {
        this.jsonClazz = parameterInfo.getParameterClazz();
        if (this.jsonClazz.equals(List.class)) {
            this.jsonGenericType = parameterInfo.getGenericTypeAt(0);
        }
    }

    private Object getJsonArgument(Repository r, String json) {
        if (this.jsonClazz.equals(String.class)) {
            return json;
        }
        if (this.jsonClazz.equals(List.class)) {
            return JsonUtils.fromList(r, json, (Class)this.jsonGenericType);
        }
        return JsonUtils.from(r, json, this.jsonClazz);
    }

    private boolean isRootCollection() {
        if (this.size() == 0) {
            return true;
        }
        if (this.size() == 1) {
            return this.count(ParameterType.JSON) == 1 || this.count(ParameterType.PARAMS) == 1;
        }
        if (this.size() == 2) {
            return this.count(ParameterType.JSON) == 1 && this.count(ParameterType.PARAMS) == 1;
        }
        return false;
    }

    private boolean isSingleObject() {
        if (this.size() == 1) {
            return this.count(ParameterType.ID) == 1;
        }
        if (this.size() == 2) {
            return this.count(ParameterType.ID) == 1 && (this.count(ParameterType.JSON) == 1 || this.count(ParameterType.PARAMS) == 1);
        }
        if (this.size() == 3) {
            return this.count(ParameterType.ID) == 1 && this.count(ParameterType.JSON) == 1 && this.count(ParameterType.PARAMS) == 1;
        }
        return false;
    }

    private boolean isParentCollection() {
        if (this.size() == 1) {
            return this.count(ParameterType.PARENT_ID) == 1;
        }
        if (this.size() == 2) {
            return this.count(ParameterType.PARENT_ID) == 1 && (this.count(ParameterType.JSON) == 1 || this.count(ParameterType.PARAMS) == 1);
        }
        if (this.size() == 3) {
            return this.count(ParameterType.PARENT_ID) == 1 && this.count(ParameterType.JSON) == 1 && this.count(ParameterType.PARAMS) == 1;
        }
        return false;
    }

    private void incrementCount(ParameterType type) {
        if (this.count.containsKey((Object)type)) {
            this.count.put(type, this.count.get((Object)type) + 1);
        } else {
            this.count.put(type, 1);
        }
    }

    private int count(ParameterType type) {
        if (!this.count.containsKey((Object)type)) {
            return 0;
        }
        return this.count.get((Object)type);
    }

    private class ParameterInfo {
        private final Class<?> parameter;
        private final Type parameterGenerics;

        public ParameterInfo(Class<?> parameter, Type parameterGenerics) {
            this.parameter = parameter;
            this.parameterGenerics = parameterGenerics;
        }

        public ParameterType getType() throws InvalidActionMethodException {
            if (this.isId()) {
                return ParameterType.ID;
            }
            if (this.isParentId()) {
                return ParameterType.PARENT_ID;
            }
            if (this.isParams()) {
                return ParameterType.PARAMS;
            }
            if (this.isJson()) {
                return ParameterType.JSON;
            }
            throw new InvalidActionMethodException();
        }

        private boolean isId() {
            if (!this.isTypeOf(IdRef.class)) {
                return false;
            }
            Type genericType = this.getGenericTypeAt(0);
            if (genericType instanceof WildcardType) {
                return true;
            }
            return genericType.equals(ActionParameters.this.endpointClazz);
        }

        public boolean isParentId() {
            if (!this.isTypeOf(IdRef.class)) {
                return false;
            }
            ObjectModel objectModel = new ObjectModel(ActionParameters.this.endpointClazz);
            Type genericType = this.getGenericTypeAt(0);
            if (genericType instanceof WildcardType) {
                return false;
            }
            return objectModel.isAncestor((Class)genericType);
        }

        public boolean isParams() {
            if (!this.isTypeOf(Map.class)) {
                return false;
            }
            Type keyClazz = this.getGenericTypeAt(0);
            Type valueClazz = this.getGenericTypeAt(1);
            return keyClazz.equals(String.class) && valueClazz.equals(String.class);
        }

        public Class<?> getParameterClazz() {
            return this.parameter;
        }

        public Type getGenericTypeAt(int index) {
            return ((ParameterizedType)this.parameterGenerics).getActualTypeArguments()[index];
        }

        private boolean isJson() {
            if (this.isTypeOf(IdRef.class)) {
                return false;
            }
            return !this.isTypeOf(Map.class);
        }

        private boolean isTypeOf(Class<?> clazz) {
            return this.parameter.equals(clazz);
        }
    }

    private static enum ParameterType {
        ID,
        PARENT_ID,
        JSON,
        PARAMS;

    }
}

