/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.hooks;

import io.yawp.commons.utils.ThrownExceptionsUtils;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.hooks.Hook;
import io.yawp.repository.query.QueryBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RepositoryHooks {
    public static void beforeShield(Repository r, Object object) {
        RepositoryHooks.invokeHooks(r, object.getClass(), object, "beforeShield");
    }

    public static void beforeSave(Repository r, Object object) {
        RepositoryHooks.invokeHooks(r, object.getClass(), object, "beforeSave");
    }

    public static void afterSave(Repository r, Object object) {
        RepositoryHooks.invokeHooks(r, object.getClass(), object, "afterSave");
    }

    public static <T> void beforeQuery(Repository r, QueryBuilder<T> q, Class<T> clazz) {
        RepositoryHooks.invokeHooks(r, clazz, q, "beforeQuery");
    }

    public static void beforeDestroy(Repository r, IdRef<?> id) {
        RepositoryHooks.invokeHooks(r, id.getClazz(), id, "beforeDestroy");
    }

    public static void afterDestroy(Repository r, IdRef<?> id) {
        RepositoryHooks.invokeHooks(r, id.getClazz(), id, "afterDestroy");
    }

    private static void invokeHooks(Repository r, Class<?> targetClazz, Object argument, String methodName) {
        for (Class<Hook> hookClazz : r.getEndpointFeatures(targetClazz).getHooks()) {
            RepositoryHooks.invokeHookMethod(r, hookClazz, methodName, argument);
        }
    }

    private static void invokeHookMethod(Repository r, Class<? extends Hook> hookClazz, String methodName, Object argument) {
        try {
            Hook hook = hookClazz.newInstance();
            hook.setRepository(r);
            Method hookMethod = RepositoryHooks.getMethod(hook, methodName, argument.getClass());
            if (hookMethod == null) {
                hookMethod = RepositoryHooks.getMethod(hook, methodName, Object.class);
            }
            if (hookMethod != null) {
                hookMethod.invoke((Object)hook, argument);
            }
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("The Hook class " + hookClazz.getSimpleName() + " must have a default constructor, and it must not throw exceptions.", ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw ThrownExceptionsUtils.handle(ex);
        }
    }

    private static Method getMethod(Object hook, String methodName, Class<?> argumentClazz) {
        try {
            return hook.getClass().getMethod(methodName, argumentClazz);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

