/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.models;

import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.repository.IdRef;
import io.yawp.repository.annotations.Id;
import io.yawp.repository.annotations.Index;
import io.yawp.repository.annotations.Json;
import io.yawp.repository.annotations.Text;
import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FieldModel {
    private Field field;

    public FieldModel(Field field) {
        this.field = field;
        field.setAccessible(true);
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    public Object getValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isId() {
        return this.field.isAnnotationPresent(Id.class);
    }

    public boolean hasIndex() {
        return this.field.getAnnotation(Index.class) != null;
    }

    public boolean isIndexNormalizable() {
        if (!this.hasIndex()) {
            throw new RuntimeException("You must add @Index annotation the the field '" + this.field.getName() + "' if you want to use it as a index in where statements.");
        }
        return this.getIndex().normalize() && this.isString();
    }

    public boolean isEnum(Object value) {
        return value != null && value instanceof Enum;
    }

    public boolean isCollection(Object value) {
        return Collection.class.isInstance(value);
    }

    public boolean isEnum() {
        return Enum.class.isAssignableFrom(this.field.getType());
    }

    public boolean isIdRef() {
        return IdRef.class.isAssignableFrom(this.field.getType());
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.field.getType());
    }

    public boolean isSaveAsJson() {
        return this.field.getAnnotation(Json.class) != null;
    }

    public boolean isSaveAsText() {
        return this.field.getAnnotation(Text.class) != null;
    }

    private Index getIndex() {
        return this.field.getAnnotation(Index.class);
    }

    public boolean isNumber() {
        if (Number.class.isAssignableFrom(this.field.getType())) {
            return true;
        }
        String name = this.field.getType().getName();
        return name.equals("int") || name.equals("long") || name.equals("double");
    }

    public boolean isInt() {
        return Integer.class.isAssignableFrom(this.field.getType()) || this.field.getType().getName().equals("int");
    }

    public boolean isLong() {
        return Long.class.isAssignableFrom(this.field.getType()) || this.field.getType().getName().equals("long");
    }

    public boolean isDate() {
        return Date.class.isAssignableFrom(this.field.getType());
    }

    private boolean isString() {
        return String.class.isAssignableFrom(this.field.getType());
    }

    public boolean isList() {
        return List.class.isAssignableFrom(this.field.getType());
    }

    public boolean isListOfIds() {
        if (!this.isList()) {
            return false;
        }
        Class<?> listGenericClazz = ReflectionUtils.getListGenericType(this.field.getGenericType());
        return IdRef.class.isAssignableFrom(listGenericClazz);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers()) || this.field.isAnnotationPresent(Transient.class);
    }
}

