/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.models;

import io.yawp.repository.IdRef;
import io.yawp.repository.models.ObjectModel;
import java.lang.reflect.Field;

public class ObjectHolder {
    private ObjectModel model;
    private Object object;

    public ObjectHolder(Object object) {
        this.object = object;
        this.model = new ObjectModel(object.getClass());
    }

    public ObjectModel getModel() {
        return this.model;
    }

    public Object getObject() {
        return this.object;
    }

    public void setId(IdRef<?> id) {
        Field idField = this.model.getIdField();
        try {
            idField.set(this.object, id);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public IdRef<?> getId() {
        Field field = this.model.getIdField();
        if (!this.model.isIdRef(field)) {
            throw new RuntimeException("@Id must be " + IdRef.class.getSimpleName());
        }
        try {
            return (IdRef)field.get(this.object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasId() {
        return this.getId() != null;
    }

    public void setParentId(IdRef<?> parentId) {
        Field parentIdField = this.model.getParentField();
        if (parentIdField == null) {
            if (parentId != null) {
                throw new RuntimeException("Trying to set parentId " + parentId + " to class " + this.object.getClass().getSimpleName() + ", but it doesn't seem to have a @Parent field.");
            }
            return;
        }
        try {
            parentIdField.set(this.object, parentId);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public IdRef<?> getParentId() {
        Field parentField = this.model.getParentField();
        if (parentField == null) {
            return null;
        }
        try {
            return (IdRef)parentField.get(this.object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

