/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.models;

import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.commons.utils.kind.KindResolver;
import io.yawp.repository.IdRef;
import io.yawp.repository.annotations.Id;
import io.yawp.repository.annotations.ParentId;
import io.yawp.repository.models.FieldModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class ObjectModel {
    private Class<?> clazz;

    public ObjectModel(Class<?> clazz) {
        this.clazz = clazz;
    }

    public String getKind() {
        return KindResolver.getKindFromClass(this.clazz);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Field getIdField() {
        return ReflectionUtils.getFieldWithAnnotation(this.clazz, Id.class);
    }

    public Field getParentField() {
        return ReflectionUtils.getFieldWithAnnotation(this.clazz, ParentId.class);
    }

    public String getIdFieldName() {
        return this.getIdField().getName();
    }

    public boolean isIdRef(Field field) {
        return IdRef.class.isAssignableFrom(field.getType());
    }

    public Class<?> getParentClazz() {
        Field parentField = this.getParentField();
        if (parentField == null) {
            return null;
        }
        return ReflectionUtils.getIdRefEndpointClazz(parentField);
    }

    public boolean hasParent() {
        return this.getParentField() != null;
    }

    public ObjectModel getParentModel() {
        return new ObjectModel(this.getParentClazz());
    }

    public Class<?> getAncestorClazz(int ancestor) {
        Class<?> parentClazz = this.clazz;
        for (int i = 0; i <= ancestor; ++i) {
            ObjectModel model = new ObjectModel(parentClazz);
            parentClazz = model.getParentClazz();
        }
        return parentClazz;
    }

    public int getAncestorNumber(Class<?> ancestorClazz) {
        if (this.clazz.equals(ancestorClazz)) {
            return -1;
        }
        Class<?> parentClazz = this.getParentClazz();
        int ancestorNumber = 0;
        while (parentClazz != null && !parentClazz.equals(ancestorClazz)) {
            ObjectModel model = new ObjectModel(parentClazz);
            parentClazz = model.getParentClazz();
            ++ancestorNumber;
        }
        if (parentClazz == null) {
            return -1;
        }
        return ancestorNumber;
    }

    public boolean isAncestor(Class<?> ancestorClazz) {
        return this.getAncestorNumber(ancestorClazz) != -1;
    }

    public List<FieldModel> getFieldModels() {
        List<Field> fields = ReflectionUtils.getFieldsRecursively(this.clazz);
        ArrayList<FieldModel> fieldModels = new ArrayList<FieldModel>();
        for (Field field : fields) {
            fieldModels.add(new FieldModel(field));
        }
        return fieldModels;
    }

    public FieldModel getFieldModel(String fieldName) {
        return new FieldModel(ReflectionUtils.getFieldRecursively(this.clazz, fieldName));
    }

    public boolean isIdShuffled() {
        return this.getIdField().getAnnotation(Id.class).shuffle();
    }

    public <T> T createInstance() {
        try {
            Constructor<?> defaultConstructor = this.clazz.getDeclaredConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return (T)defaultConstructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An exception was thrown when calling the default constructor of the class " + this.clazz.getSimpleName() + ": ", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The class " + this.clazz.getSimpleName() + " must have a default constructor and cannot be an non-static inner class.", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("The class " + this.clazz.getSimpleName() + " must cannot be abstract.", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException("Unexpected error: ", e);
        }
    }
}

