/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.pipes;

import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.repository.Feature;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.pipes.pump.IdPump;
import io.yawp.repository.pipes.pump.PumpGenerator;
import io.yawp.repository.query.QueryBuilder;
import java.util.List;
import java.util.Set;

public abstract class Pipe<T, S>
extends Feature {
    private static final int BATCH_SIZE = 30;
    private Class<T> sourceClazz;
    private Class<S> sinkClazz;
    private IdPump<T> sourcePump;
    private IdPump<S> sinkPump;

    public static Pipe newInstance(Repository r, Class<? extends Pipe> pipeClazz) {
        try {
            Class<?> sourceClazz = ReflectionUtils.getFeatureEndpointClazz(pipeClazz);
            Class<?> sinkClazz = ReflectionUtils.getFeatureTypeArgumentAt(pipeClazz, 1);
            Pipe pipe = pipeClazz.newInstance();
            pipe.setRepository(r);
            pipe.init(sourceClazz, sinkClazz);
            return pipe;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public final void init(Class<T> sourceClazz, Class<S> sinkClazz) {
        this.sourceClazz = sourceClazz;
        this.sinkClazz = sinkClazz;
        this.sourcePump = new IdPump<T>(sourceClazz, 30);
        this.sinkPump = new IdPump<S>(sinkClazz, 30);
    }

    public abstract void configureSinks(T var1);

    public final void addSinkId(IdRef<S> id) {
        this.sinkPump.add(id);
    }

    public final void addSinkIds(List<IdRef<S>> ids) {
        this.sinkPump.addAll(ids);
    }

    public final void addSinkIdsQuery(QueryBuilder<S> query) {
        this.sinkPump.addQuery(query);
    }

    public final void addSinkIdsGenerator(PumpGenerator<IdRef<S>> generator) {
        this.sinkPump.addGenerator(generator);
    }

    public abstract void flux(T var1, S var2);

    public abstract void reflux(T var1, S var2);

    public boolean reflowCondition(S newSink, S oldSink) {
        return false;
    }

    public void configureSources(S sink) {
    }

    public void addSourceId(IdRef<T> source) {
        this.sourcePump.add(source);
    }

    public void addSourceIds(List<IdRef<T>> sources) {
        this.sourcePump.addAll(sources);
    }

    public void addSourceIdsQuery(QueryBuilder<T> query) {
        this.sourcePump.addQuery(query);
    }

    public void addSourceIdsGenerator(PumpGenerator<IdRef<T>> generator) {
        this.sourcePump.addGenerator(generator);
    }

    public void drain(S sink) {
    }

    public final Set<IdRef<S>> allSinks() {
        return this.sinkPump.all();
    }

    public final boolean hasSinks() {
        return this.sinkPump.hasMore();
    }

    public final void forceSink(IdRef<S> sinkId) {
        this.sinkPump = new IdPump<S>(this.sinkClazz, 30);
        this.sinkPump.add(sinkId);
    }

    public IdPump<T> getSourcePump() {
        return this.sourcePump;
    }
}

