/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.pipes;

import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.models.ObjectHolder;
import io.yawp.repository.pipes.Pipe;
import io.yawp.repository.query.NoResultException;

public class RepositoryPipes {
    public static void flux(Repository r, Object source) {
        Class<?> endpointClazz = source.getClass();
        if (!RepositoryPipes.isPipeSource(r, endpointClazz)) {
            return;
        }
        for (Class<Pipe> pipeClazz : r.getEndpointFeatures(endpointClazz).getPipes()) {
            Pipe pipe = Pipe.newInstance(r, pipeClazz);
            r.driver().pipes().flux(pipe, source);
        }
    }

    public static void reflux(Repository r, IdRef<?> id) {
        Object source;
        Class<?> endpointClazz = id.getClazz();
        if (!RepositoryPipes.isPipeSource(r, endpointClazz)) {
            return;
        }
        try {
            source = id.fetch();
        }
        catch (NoResultException e) {
            return;
        }
        for (Class<Pipe> pipeClazz : r.getEndpointFeatures(endpointClazz).getPipes()) {
            Pipe pipe = Pipe.newInstance(r, pipeClazz);
            r.driver().pipes().reflux(pipe, source);
        }
    }

    public static void updateExisting(Repository r, Object object) {
        Object oldObject;
        Class<?> endpointClazz = object.getClass();
        if (!RepositoryPipes.isPipeSourceOrSink(r, endpointClazz)) {
            return;
        }
        try {
            oldObject = RepositoryPipes.fetchOldObject(object);
        }
        catch (NoResultException e) {
            return;
        }
        RepositoryPipes.refluxOld(r, endpointClazz, object, oldObject);
        RepositoryPipes.reflowSink(r, endpointClazz, object, oldObject);
    }

    private static void refluxOld(Repository r, Class<?> endpointClazz, Object source, Object oldSource) {
        if (!RepositoryPipes.isPipeSource(r, endpointClazz)) {
            return;
        }
        for (Class<Pipe> pipeClazz : r.getEndpointFeatures(endpointClazz).getPipes()) {
            Pipe pipe = Pipe.newInstance(r, pipeClazz);
            r.driver().pipes().refluxOld(pipe, source, oldSource);
        }
    }

    private static void reflowSink(Repository r, Class<?> endpointClazz, Object sink, Object oldSink) {
        if (!RepositoryPipes.isPipeSink(r, endpointClazz)) {
            return;
        }
        for (Class<Pipe> pipeClazz : r.getEndpointFeatures(endpointClazz).getPipesSink()) {
            Pipe pipe = Pipe.newInstance(r, pipeClazz);
            if (!pipe.reflowCondition(sink, oldSink)) continue;
            r.driver().pipes().reflow(pipe, sink);
        }
    }

    private static Object fetchOldObject(Object object) {
        ObjectHolder objectHolder = new ObjectHolder(object);
        if (objectHolder.getId() == null) {
            throw new NoResultException();
        }
        return objectHolder.getId().fetch();
    }

    public static boolean isPipeSourceOrSink(Repository r, Class<?> endpointClazz) {
        return RepositoryPipes.isPipeSource(r, endpointClazz) || RepositoryPipes.isPipeSink(r, endpointClazz);
    }

    public static boolean isPipeSource(Repository r, Class<?> endpointClazz) {
        return r.getFeatures() != null && r.getEndpointFeatures(endpointClazz).getPipes().size() != 0;
    }

    public static boolean isPipeSink(Repository r, Class<?> endpointClazz) {
        return r.getEndpointFeatures(endpointClazz).getPipesSink().size() != 0;
    }
}

