/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.pipes.pump;

import io.yawp.commons.utils.JsonUtils;
import io.yawp.repository.Yawp;
import io.yawp.repository.pipes.pump.PumpGenerator;
import io.yawp.repository.query.QueryBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Pump<T>
implements Serializable {
    private static final long serialVersionUID = -1147341944765139597L;
    protected Class<?> clazz;
    protected int defaultBatchSize;
    private List<T> objects = new ArrayList<T>();
    protected int queryIndex = 0;
    private String cursor;
    private List<PumpGenerator<T>> generators = new ArrayList<PumpGenerator<T>>();
    private int generatorIndex = 0;

    public Pump(Class<?> clazz, int batchSize) {
        this.clazz = clazz;
        this.defaultBatchSize = batchSize;
    }

    public abstract void addQuery(QueryBuilder<?> var1);

    protected abstract QueryBuilder<?> getQueryAt(int var1);

    protected abstract List<T> executeQueryAt(int var1);

    protected abstract int getQueriesSize();

    public void add(T object) {
        this.objects.add(object);
    }

    public void addAll(List<T> newObjects) {
        this.objects.addAll(newObjects);
    }

    public void addGenerator(PumpGenerator<T> generator) {
        this.generators.add(generator);
    }

    public List<T> more() {
        if (this.hasMoreObjects()) {
            List<T> list = this.moreFromList();
            if (list.size() < this.defaultBatchSize && this.hasMoreQueries()) {
                list.addAll(this.moreFromQuery(this.defaultBatchSize - list.size()));
            }
            return list;
        }
        if (this.hasMoreQueries()) {
            List<T> list = this.moreFromQuery(this.defaultBatchSize);
            if (list.size() < this.defaultBatchSize && this.hasMoreGenerators()) {
                list.addAll(this.moreFromGenerators(this.defaultBatchSize - list.size()));
            }
            return list;
        }
        return this.moreFromGenerators(this.defaultBatchSize);
    }

    private List<T> moreFromList() {
        ArrayList<T> list = new ArrayList<T>();
        int fromIndex = 0;
        int toIndex = this.defaultBatchSize;
        if (toIndex >= this.objects.size()) {
            toIndex = this.objects.size();
        }
        List<T> subList = this.objects.subList(fromIndex, toIndex);
        list.addAll(subList);
        subList.clear();
        return list;
    }

    private List<T> moreFromQuery(int batchSize) {
        List<T> list = this.executeQueryAt(batchSize, this.queryIndex);
        if (list.size() < batchSize) {
            ++this.queryIndex;
            this.cursor = null;
            if (this.hasMoreQueries()) {
                list.addAll(this.moreFromQuery(this.defaultBatchSize - list.size()));
            }
        }
        return list;
    }

    private List<T> moreFromGenerators(int batchSize) {
        PumpGenerator<T> generator = this.generators.get(this.generatorIndex);
        List<T> list = generator.more(batchSize);
        if (list.size() < batchSize) {
            ++this.generatorIndex;
            if (this.hasMoreGenerators()) {
                list.addAll(this.moreFromGenerators(this.defaultBatchSize - list.size()));
            }
        }
        return list;
    }

    private List<T> executeQueryAt(int batchSize, int queryIndex) {
        QueryBuilder<?> q = this.getQueryAt(queryIndex);
        this.configureQuery(batchSize, q);
        List<T> list = this.executeQueryAt(queryIndex);
        this.cursor = q.getCursor();
        return list;
    }

    private void configureQuery(int batchSize, QueryBuilder<?> q) {
        if (this.cursor != null) {
            q.cursor(this.cursor);
        }
        q.limit(batchSize);
    }

    public Set<T> all() {
        HashSet<T> all = new HashSet<T>();
        while (this.hasMore()) {
            all.addAll(this.more());
        }
        return all;
    }

    public boolean hasMore() {
        return this.hasMoreObjects() || this.hasMoreQueries() || this.hasMoreGenerators();
    }

    protected boolean hasMoreQueries() {
        return this.queryIndex < this.getQueriesSize();
    }

    private boolean hasMoreGenerators() {
        if (this.generatorIndex >= this.generators.size()) {
            return false;
        }
        return this.generators.get(this.generatorIndex).hasMore();
    }

    private boolean hasMoreObjects() {
        return this.objects.size() != 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.clazz);
        out.writeInt(this.defaultBatchSize);
        out.writeInt(this.queryIndex);
        out.writeObject(this.cursor);
        out.writeObject(this.generators);
        out.writeInt(this.generatorIndex);
        this.writeObjects(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.clazz = (Class)in.readObject();
        this.defaultBatchSize = in.readInt();
        this.queryIndex = in.readInt();
        this.cursor = (String)in.readObject();
        this.generators = (List)in.readObject();
        this.generatorIndex = in.readInt();
        this.objects = this.readObjects(in);
    }

    private List<T> readObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
        List jsonList = (List)in.readObject();
        ArrayList objects = new ArrayList();
        for (String json : jsonList) {
            objects.add(JsonUtils.from(Yawp.yawp(), json, this.clazz));
        }
        return objects;
    }

    private void writeObjects(ObjectOutputStream out) throws IOException {
        ArrayList<String> jsonList = new ArrayList<String>();
        for (T object : this.objects) {
            jsonList.add(JsonUtils.to(object));
        }
        out.writeObject(jsonList);
    }
}

