/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.query;

import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.models.ObjectModel;
import io.yawp.repository.query.MoreThanOneResultException;
import io.yawp.repository.query.NoResultException;
import io.yawp.repository.query.QueryOptions;
import io.yawp.repository.query.QueryOrder;
import io.yawp.repository.query.QueryTransformer;
import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.query.condition.Condition;
import io.yawp.repository.query.condition.SimpleCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class QueryBuilder<T> {
    private Class<T> clazz;
    private ObjectModel model;
    private Repository r;
    private IdRef<?> parentId;
    private BaseCondition condition;
    private List<QueryOrder> preOrders = new ArrayList<QueryOrder>();
    private List<QueryOrder> postOrders = new ArrayList<QueryOrder>();
    private Integer limit;
    private String cursor;

    public static <T> QueryBuilder<T> q(Class<T> clazz, Repository r) {
        return new QueryBuilder<T>(clazz, r);
    }

    private QueryBuilder(Class<T> clazz, Repository r) {
        this.clazz = clazz;
        this.r = r;
        this.model = new ObjectModel(clazz);
    }

    public <N> QueryTransformer<T, N> transform(String transformName) {
        return new QueryTransformer(this, transformName);
    }

    public QueryBuilder<T> and(String field, String operator, Object value) {
        return this.where(field, operator, value);
    }

    public QueryBuilder<T> where(String field, String operator, Object value) {
        return this.where(Condition.c(field, operator, value));
    }

    public QueryBuilder<T> where(BaseCondition c) {
        this.condition = this.condition == null ? c : Condition.and(this.condition, c);
        this.condition.init(this.r, this.clazz);
        return this;
    }

    public QueryBuilder<T> and(BaseCondition c) {
        return this.where(c);
    }

    public QueryBuilder<T> from(IdRef<?> parentId) {
        if (parentId == null) {
            this.parentId = null;
            return this;
        }
        this.parentId = parentId;
        return this;
    }

    public QueryBuilder<T> order(String property) {
        this.order(property, null);
        return this;
    }

    public QueryBuilder<T> order(String property, String direction) {
        this.preOrders.add(new QueryOrder(null, property, direction));
        return this;
    }

    public QueryBuilder<T> sort(String property) {
        this.sort(property, null);
        return this;
    }

    public QueryBuilder<T> sort(String property, String direction) {
        this.sort(null, property, direction);
        return this;
    }

    public QueryBuilder<T> sort(String entity, String property, String direction) {
        this.postOrders.add(new QueryOrder(entity, property, direction));
        return this;
    }

    public QueryBuilder<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder<T> cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public IdRef<?> getParentId() {
        return this.parentId;
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public QueryBuilder<T> options(QueryOptions options) {
        if (options.getCondition() != null) {
            this.where(options.getCondition());
        }
        if (options.getPreOrders() != null) {
            this.preOrders.addAll(options.getPreOrders());
        }
        if (options.getPostOrders() != null) {
            this.postOrders.addAll(options.getPostOrders());
        }
        if (options.getLimit() != null) {
            this.limit(options.getLimit());
        }
        if (options.getCursor() != null) {
            this.cursor(options.getCursor());
        }
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<QueryOrder> getPreOrders() {
        return this.preOrders;
    }

    public BaseCondition getCondition() {
        return this.condition;
    }

    public Repository getRepository() {
        return this.r;
    }

    public ObjectModel getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> executeQueryList() {
        this.r.namespace().set(this.getClazz());
        try {
            List<T> list = this.executeQuery();
            return list;
        }
        finally {
            this.r.namespace().reset();
        }
    }

    public List<T> list() {
        List<T> list = this.executeQueryList();
        this.sortList(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T first() {
        this.r.namespace().set(this.getClazz());
        try {
            if (this.isQueryById()) {
                T t = this.executeQueryById();
                return t;
            }
            T t = this.executeQueryFirst();
            return t;
        }
        finally {
            this.r.namespace().reset();
        }
    }

    private T executeQueryFirst() {
        this.limit(1);
        List<T> list = this.executeQuery();
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T only() throws NoResultException, MoreThanOneResultException {
        this.r.namespace().set(this.getClazz());
        try {
            T object = null;
            object = this.isQueryById() ? (T)this.executeQueryById() : (T)this.executeQueryOnly();
            if (object == null) {
                throw new NoResultException();
            }
            T t = object;
            return t;
        }
        finally {
            this.r.namespace().reset();
        }
    }

    private T executeQueryOnly() throws MoreThanOneResultException {
        List<T> list = this.executeQuery();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new MoreThanOneResultException();
    }

    private List<T> executeQuery() {
        List objects = this.r.driver().query().objects(this);
        return this.postFilter(objects);
    }

    private List<T> postFilter(List<T> objects) {
        if (!this.hasPostFilter()) {
            return objects;
        }
        return this.condition.applyPostFilter(objects);
    }

    private boolean hasPostFilter() {
        return this.condition != null && this.condition.hasPostFilter();
    }

    private T executeQueryById() {
        SimpleCondition c = (SimpleCondition)this.condition;
        IdRef id = (IdRef)c.getWhereValue();
        return this.r.driver().query().fetch(id);
    }

    private boolean isQueryById() {
        if (this.condition == null || !(this.condition instanceof SimpleCondition)) {
            return false;
        }
        SimpleCondition c = (SimpleCondition)this.condition;
        return c.isIdField() && c.isEqualOperator();
    }

    public void sortList(List<?> objects) {
        if (!this.hasPostOrder()) {
            return;
        }
        Collections.sort(objects, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                for (QueryOrder order : QueryBuilder.this.postOrders) {
                    int compare = order.compare(o1, o2);
                    if (compare == 0) continue;
                    return compare;
                }
                return 0;
            }
        });
    }

    public boolean hasPreOrder() {
        return this.preOrders.size() != 0;
    }

    private boolean hasPostOrder() {
        return this.postOrders.size() != 0;
    }

    protected Class<T> getClazz() {
        return this.clazz;
    }

    public QueryBuilder<T> whereById(String operator, IdRef<?> id) {
        return this.from(id.getParentId()).where(this.model.getIdField().getName(), operator, id);
    }

    public T fetch(IdRef<?> idRef) {
        return this.whereById("=", idRef).only();
    }

    public T fetch(Long id) {
        IdRef<T> idRef = IdRef.create(this.r, this.clazz, id);
        return this.fetch(idRef);
    }

    public T fetch(String name) {
        IdRef<T> idRef = IdRef.create(this.r, this.clazz, name);
        return this.fetch(idRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IdRef<T>> ids() {
        if (this.hasPostFilter() || this.hasPostOrder()) {
            throw new RuntimeException("ids() cannot be used with post query filter or order. You may need to add @Index to your model attributes.");
        }
        this.r.namespace().set(this.getClazz());
        try {
            List ids;
            List list = ids = this.r.driver().query().ids(this);
            return list;
        }
        finally {
            this.r.namespace().reset();
        }
    }

    public IdRef<T> onlyId() throws NoResultException, MoreThanOneResultException {
        List<IdRef<T>> ids = this.ids();
        if (ids.size() == 0) {
            throw new NoResultException();
        }
        if (ids.size() > 1) {
            throw new MoreThanOneResultException();
        }
        return ids.get(0);
    }
}

