/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.query;

import io.yawp.commons.utils.ReflectionUtils;

public class QueryOrder {
    private String entity;
    private String property;
    private String direction;

    public QueryOrder(String entity, String property, String direction) {
        this.entity = entity;
        this.property = property;
        this.direction = direction;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public boolean isAsc() {
        if (this.direction == null) {
            return true;
        }
        return this.direction.equalsIgnoreCase("asc");
    }

    public boolean isDesc() {
        if (this.direction == null) {
            return false;
        }
        return this.direction.equalsIgnoreCase("desc");
    }

    public int compare(Object o1, Object o2) {
        Comparable value1 = this.getComparable(o1);
        Comparable value2 = this.getComparable(o2);
        if (value1 == null) {
            if (value2 == null) {
                return 0;
            }
            return this.isAsc() ? -1 : 1;
        }
        if (value2 == null) {
            return this.isAsc() ? 1 : -1;
        }
        int compare = value1.compareTo(value2);
        if (this.isDesc()) {
            compare *= -1;
        }
        return compare;
    }

    private Comparable getComparable(Object o) {
        if (this.entity != null) {
            Object innerObject = ReflectionUtils.getter(o, this.entity);
            return (Comparable)ReflectionUtils.getter(innerObject, this.property);
        }
        return (Comparable)ReflectionUtils.getter(o, this.property);
    }
}

