/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.query;

import io.yawp.repository.IdRef;
import io.yawp.repository.query.QueryBuilder;
import io.yawp.repository.query.QueryOptions;
import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.transformers.RepositoryTransformers;
import java.util.ArrayList;
import java.util.List;

public class QueryTransformer<F, T> {
    private QueryBuilder<F> query;
    private String transformName;

    public QueryTransformer(QueryBuilder<F> query, String transformName) {
        this.query = query;
        this.transformName = transformName;
    }

    public QueryTransformer<F, T> where(String field, String operator, Object value) {
        this.query.where(field, operator, value);
        return this;
    }

    public QueryTransformer<F, T> where(BaseCondition c) {
        this.query.where(c);
        return this;
    }

    public QueryTransformer<F, T> order(String property) {
        this.order(property, null);
        return this;
    }

    public QueryTransformer<F, T> order(String property, String direction) {
        this.query.order(property, direction);
        return this;
    }

    public QueryTransformer<F, T> sort(String property) {
        this.sort(property, null);
        return this;
    }

    public QueryTransformer<F, T> sort(String property, String direction) {
        this.query.sort(property, direction);
        return this;
    }

    public QueryTransformer<F, T> sort(String entity, String property, String direction) {
        this.query.sort(entity, property, direction);
        return this;
    }

    public QueryTransformer<F, T> limit(int limit) {
        this.query.limit(limit);
        return this;
    }

    public QueryTransformer<F, T> cursor(String cursor) {
        this.query.cursor(cursor);
        return this;
    }

    public String getCursor() {
        return this.query.getCursor();
    }

    public QueryTransformer<F, T> options(QueryOptions options) {
        this.query.options(options);
        return this;
    }

    public List<T> list() {
        ArrayList transformedList = new ArrayList();
        List<F> list = this.query.executeQueryList();
        for (F object : list) {
            transformedList.add(RepositoryTransformers.execute(this.query.getRepository(), object, this.transformName));
        }
        this.query.sortList(transformedList);
        return transformedList;
    }

    public T first() {
        return RepositoryTransformers.execute(this.query.getRepository(), this.query.first(), this.transformName);
    }

    public T only() {
        return RepositoryTransformers.execute(this.query.getRepository(), this.query.only(), this.transformName);
    }

    public T fetch(IdRef<?> idRef) {
        return RepositoryTransformers.execute(this.query.getRepository(), this.query.fetch(idRef), this.transformName);
    }

    public T fetch(Long id) {
        return RepositoryTransformers.execute(this.query.getRepository(), this.query.fetch(id), this.transformName);
    }

    public T fetch(String name) {
        return RepositoryTransformers.execute(this.query.getRepository(), this.query.fetch(name), this.transformName);
    }
}

