/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.query.condition;

import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.query.condition.Condition;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseCondition {
    protected static final Class<?>[] VALID_ID_CLASSES = new Class[]{IdRef.class, Long.class, String.class};

    public abstract void init(Repository var1, Class<?> var2);

    public abstract boolean hasPreFilter();

    public abstract boolean hasPostFilter();

    public abstract boolean evaluate(Object var1);

    public abstract BaseCondition not();

    public BaseCondition and(BaseCondition c) {
        return Condition.and(this, c);
    }

    public BaseCondition or(BaseCondition c) {
        return Condition.or(this, c);
    }

    public <T> List<T> applyPostFilter(List<T> objects) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            if (!this.evaluate(object)) continue;
            result.add(object);
        }
        return result;
    }
}

