/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.query.condition;

import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.repository.IdRef;
import io.yawp.repository.models.ObjectHolder;
import io.yawp.repository.models.ObjectModel;
import io.yawp.repository.query.condition.ConditionForChildException;

public class ConditionReference {
    private static final String PARENT_REF_KEYWORK = "parent";
    private String[] split;
    private int current;
    private Object object;
    private ObjectHolder objectHolder;
    private Class<?> clazz;
    private ObjectModel model;
    private String refString;

    public ConditionReference(String refString, Class<?> clazz, Object object) {
        this.refString = refString;
        this.clazz = clazz;
        this.model = new ObjectModel(clazz);
        this.object = object;
        this.objectHolder = new ObjectHolder(object);
        this.split = refString.split("->");
        this.current = 0;
    }

    private boolean hasMoreRefs() {
        return this.current < this.split.length - 1;
    }

    private String nextRef() {
        return this.split[this.current++];
    }

    private boolean isParentRef() {
        return this.split[this.current].equalsIgnoreCase(PARENT_REF_KEYWORK);
    }

    private String fieldName() {
        return this.split[this.split.length - 1];
    }

    public Object getValue() throws ConditionForChildException {
        this.verifyIfConditionIsForChild();
        Object currentObject = this.advanceAncestorSequenceIfNecessary();
        while (this.hasMoreRefs()) {
            IdRef objectId = (IdRef)ReflectionUtils.getFieldValue(currentObject, this.nextRef());
            if (objectId == null) {
                return null;
            }
            currentObject = objectId.fetch();
        }
        return ReflectionUtils.getFieldValue(currentObject, this.fieldName());
    }

    private void verifyIfConditionIsForChild() throws ConditionForChildException {
        if (this.clazz != null && this.isObjectAcenstor() && this.isReferenceForChild()) {
            throw new ConditionForChildException();
        }
    }

    private Object advanceAncestorSequenceIfNecessary() {
        if (this.isObjectAcenstor()) {
            this.advanceToTheRightAncestor();
        }
        if (!this.isParentRef()) {
            return this.object;
        }
        IdRef<Object> parentId = this.objectHolder.getParentId();
        this.nextRef();
        while (this.isParentRef()) {
            parentId = parentId.getParentId();
            this.nextRef();
        }
        return parentId.fetch();
    }

    private void advanceToTheRightAncestor() {
        if (this.clazz == null || this.object.getClass().equals(this.clazz)) {
            return;
        }
        Class<?> ancestorClazz = this.clazz;
        int i = 0;
        while (!this.object.getClass().equals(ancestorClazz)) {
            ancestorClazz = this.model.getAncestorClazz(i);
            if (ancestorClazz == null) {
                throw new RuntimeException("Invalid condition ref " + this.refString + " for object class: " + this.object.getClass().getName());
            }
            this.nextRef();
            ++i;
        }
    }

    private boolean isObjectAcenstor() {
        return !this.object.getClass().equals(this.clazz);
    }

    private boolean isReferenceForChild() {
        int ancestorRefNumber = -1;
        for (int i = 0; i < this.split.length - 1 && this.split[i].equals(PARENT_REF_KEYWORK); ++i) {
            ++ancestorRefNumber;
        }
        return this.model.getAncestorNumber(this.object.getClass()) > ancestorRefNumber;
    }
}

