/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.query.condition;

import io.yawp.repository.Repository;
import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.query.condition.LogicalOperator;

public class JoinedCondition
extends BaseCondition {
    private LogicalOperator logicalOperator;
    private BaseCondition[] conditions;
    private boolean hasPreFilter = false;
    private boolean hasPostFilter = false;

    public JoinedCondition(LogicalOperator logicalOperator, BaseCondition[] conditions) {
        this.logicalOperator = logicalOperator;
        this.conditions = conditions;
    }

    @Override
    public void init(Repository r, Class<?> clazz) {
        boolean allSubConditionsHasPreFilter = true;
        boolean oneSubConditionHasPreFilter = false;
        for (BaseCondition c : this.conditions) {
            c.init(r, clazz);
            if (!c.hasPreFilter()) {
                allSubConditionsHasPreFilter = false;
            } else {
                oneSubConditionHasPreFilter = true;
            }
            if (!c.hasPostFilter()) continue;
            this.hasPostFilter = true;
        }
        this.hasPreFilter = oneSubConditionHasPreFilter && this.logicalOperator == LogicalOperator.AND || allSubConditionsHasPreFilter && this.logicalOperator == LogicalOperator.OR;
    }

    public LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    public BaseCondition[] getConditions() {
        return this.conditions;
    }

    @Override
    public boolean hasPreFilter() {
        return this.hasPreFilter;
    }

    @Override
    public boolean hasPostFilter() {
        return this.hasPostFilter;
    }

    @Override
    public boolean evaluate(Object object) {
        if (this.logicalOperator == LogicalOperator.AND) {
            return this.evaluateAnd(object);
        }
        return this.evaluateOr(object);
    }

    private boolean evaluateOr(Object object) {
        boolean result = false;
        for (BaseCondition condition : this.conditions) {
            boolean bl = result = result || condition.evaluate(object);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateAnd(Object object) {
        boolean result = true;
        for (BaseCondition condition : this.conditions) {
            boolean bl = result = result && condition.evaluate(object);
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public BaseCondition not() {
        BaseCondition[] reversedConditions = new BaseCondition[this.conditions.length];
        for (int i = 0; i < this.conditions.length; ++i) {
            reversedConditions[i] = this.conditions[i].not();
        }
        return new JoinedCondition(this.logicalOperator.not(), reversedConditions);
    }
}

