/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.query.condition;

import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.models.FieldModel;
import io.yawp.repository.models.ObjectModel;
import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.query.condition.ConditionForChildException;
import io.yawp.repository.query.condition.ConditionReference;
import io.yawp.repository.query.condition.WhereOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleCondition
extends BaseCondition {
    private Repository r;
    private Class<?> clazz;
    private ObjectModel model;
    private String field;
    private WhereOperator whereOperator;
    private Object whereValue;

    public SimpleCondition(String field, WhereOperator whereOperator, Object value) {
        this.field = field;
        this.whereOperator = whereOperator;
        this.whereValue = value;
        if (whereOperator == WhereOperator.IN) {
            this.assertIsList(value);
        }
    }

    @Override
    public void init(Repository r, Class<?> clazz) {
        this.r = r;
        this.clazz = clazz;
        this.model = new ObjectModel(clazz);
        this.normalizeIdRefs();
    }

    public String getField() {
        return this.field;
    }

    public WhereOperator getWhereOperator() {
        return this.whereOperator;
    }

    public Object getWhereValue() {
        return this.whereValue;
    }

    public boolean isEqualOperator() {
        return this.whereOperator == WhereOperator.EQUAL;
    }

    public boolean isIdField() {
        return this.field.equals(this.model.getIdField().getName());
    }

    @Override
    public boolean hasPreFilter() {
        if (this.isRefField()) {
            return false;
        }
        FieldModel fieldModel = this.model.getFieldModel(this.field);
        return fieldModel.hasIndex() || fieldModel.isId();
    }

    @Override
    public boolean hasPostFilter() {
        return !this.hasPreFilter();
    }

    private boolean isRefField() {
        return this.field.indexOf("->") != -1;
    }

    @Override
    public boolean evaluate(Object object) {
        try {
            Object objectValue = new ConditionReference(this.field, this.clazz, object).getValue();
            return this.whereOperator.evaluate(objectValue, this.whereValue);
        }
        catch (ConditionForChildException e) {
            return true;
        }
    }

    @Override
    public BaseCondition not() {
        return new SimpleCondition(this.field, this.whereOperator.reverse(), this.whereValue);
    }

    private void normalizeIdRefs() {
        if (this.isIdField()) {
            if (this.whereValue instanceof String) {
                this.whereValue = IdRef.parse(this.r, (String)this.whereValue);
            } else if (this.whereValue instanceof List) {
                this.whereValue = this.convertToIdRefs((List)this.whereValue);
            }
        }
    }

    private void assertIsList(Object value) {
        if (value == null) {
            return;
        }
        Class<?> valueClazz = value.getClass();
        if (!valueClazz.isArray() && !Collection.class.isAssignableFrom(valueClazz)) {
            throw new RuntimeException("Unsupported 'in' type: must be a primtive array or a Collection<?>. Found " + valueClazz.getSimpleName());
        }
    }

    private List<IdRef<?>> convertToIdRefs(List<?> rawIds) {
        ArrayList ids = new ArrayList();
        for (Object rawId : rawIds) {
            if (rawId instanceof String) {
                ids.add(IdRef.parse(this.r, (String)rawId));
                continue;
            }
            ids.add((IdRef)rawId);
        }
        return ids;
    }
}

