/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.scanner;

import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.repository.actions.Action;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.actions.ActionMethod;
import io.yawp.repository.actions.InvalidActionMethodException;
import io.yawp.repository.hooks.Hook;
import io.yawp.repository.pipes.Pipe;
import io.yawp.repository.scanner.FeatureTree;
import io.yawp.repository.shields.Shield;
import io.yawp.repository.shields.ShieldInfo;
import io.yawp.repository.transformers.Transformer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EndpointTree<T> {
    private Class<?> endpointClazz;
    private FeatureTree<Action> actionTree = new FeatureTree<Action>(Action.class);
    private FeatureTree<Hook> hookTree = new FeatureTree<Hook>(Hook.class);
    private FeatureTree<Transformer> transformerTree = new FeatureTree<Transformer>(Transformer.class);
    private FeatureTree<Shield> shieldTree = new FeatureTree<Shield>(Shield.class);
    private FeatureTree<Pipe> pipeTree = new FeatureTree<Pipe>(Pipe.class);
    private List<Class<? extends Pipe>> pipesSink = new ArrayList<Class<? extends Pipe>>();

    public EndpointTree(Class<T> endpointClazz) {
        this.endpointClazz = endpointClazz;
    }

    public void addAction(Class<? extends Action> actionClazz) {
        this.actionTree.add(actionClazz);
    }

    public void addTransformer(Class<? extends Transformer> transformerClazz) {
        this.transformerTree.add(transformerClazz);
    }

    public void addHook(Class<? extends Hook> hookClazz) {
        this.hookTree.add(hookClazz);
    }

    public void addShield(Class<? extends Shield> shieldClazz) {
        this.shieldTree.add(shieldClazz);
    }

    public void addPipe(Class<? extends Pipe> pipeClazz) {
        this.pipeTree.add(pipeClazz);
    }

    public void addPipeSink(Class<? extends Pipe> pipeClazz) {
        this.pipesSink.add(pipeClazz);
    }

    public Map<ActionKey, ActionMethod> loadActions(Map<Class<?>, Map<ActionKey, ActionMethod>> cache) {
        HashMap<ActionKey, ActionMethod> map = new HashMap<ActionKey, ActionMethod>();
        for (Class<Action> actionClazz : this.actionTree.getLeafs()) {
            this.addActionKeys(map, actionClazz, cache);
        }
        return map;
    }

    public Map<String, Method> loadTransformers(Map<Class<?>, Map<String, Method>> cache) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Class<Transformer> transformerClazz : this.transformerTree.getLeafs()) {
            this.addTransformerMethods(map, transformerClazz, cache);
        }
        return map;
    }

    public Set<Class<? extends Hook>> loadHooks() {
        return this.hookTree.getLeafs();
    }

    public <TT> ShieldInfo<TT> loadShield() {
        Set<Class<? extends Shield>> shieldClazzes = this.shieldTree.getLeafs();
        if (shieldClazzes.size() == 0) {
            return null;
        }
        if (shieldClazzes.size() > 1) {
            this.throwExceptionMultipleShields(shieldClazzes);
        }
        return new ShieldInfo(shieldClazzes.iterator().next());
    }

    public Set<Class<? extends Pipe>> loadPipes() {
        return this.pipeTree.getLeafs();
    }

    public List<Class<? extends Pipe>> loadPipesSink() {
        return this.pipesSink;
    }

    private void throwExceptionMultipleShields(Set<Class<? extends Shield>> shieldClazzes) {
        throw new RuntimeException(String.format("Trying to add multiple shields for endpoint '%s' -> %s", this.endpointClazz.getName(), this.createShieldsString(shieldClazzes)));
    }

    private String createShieldsString(Set<Class<? extends Shield>> shieldClazzes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Class<? extends Shield> shieldClazz : shieldClazzes) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(shieldClazz.getName());
        }
        return sb.toString();
    }

    private void addTransformerMethods(Map<String, Method> map, Class<? extends Transformer> transformerClazz, Map<Class<?>, Map<String, Method>> cache) {
        if (cache.containsKey(transformerClazz)) {
            map.putAll(cache.get(transformerClazz));
            return;
        }
        HashMap<String, Method> addToCache = new HashMap<String, Method>();
        cache.put(transformerClazz, addToCache);
        for (Method method : ReflectionUtils.getPublicMethodsRecursively(transformerClazz, Transformer.class)) {
            String name = method.getName();
            if (this.isTransformerOverriden(name, addToCache)) continue;
            this.assertTransformerNotDuplicated(map, name, method);
            map.put(name, method);
            addToCache.put(name, method);
        }
    }

    private boolean isTransformerOverriden(String name, Map<String, Method> addToCache) {
        return addToCache.containsKey(name);
    }

    private void assertTransformerNotDuplicated(Map<String, Method> map, String name, Method method) {
        if (map.containsKey(name)) {
            Method existingMethod = map.get(name);
            if (method.equals(existingMethod)) {
                return;
            }
            throw new RuntimeException("Trying to add two transformers with the same name '" + name + "' to " + this.endpointClazz.getName() + ": one at " + existingMethod.getDeclaringClass().getName() + " and the other at " + method.getDeclaringClass().getName());
        }
    }

    private void addActionKeys(Map<ActionKey, ActionMethod> map, Class<? extends Action> actionClazz, Map<Class<?>, Map<ActionKey, ActionMethod>> cache) {
        if (cache.containsKey(actionClazz)) {
            map.putAll(cache.get(actionClazz));
            return;
        }
        HashMap<ActionKey, ActionMethod> addToCache = new HashMap<ActionKey, ActionMethod>();
        cache.put(actionClazz, addToCache);
        for (Method method : ReflectionUtils.getPublicMethodsRecursively(actionClazz, Action.class)) {
            if (!ActionMethod.isAction(method)) continue;
            ActionMethod actionMethod = this.createActionMethod(method);
            List<ActionKey> actionKeys = actionMethod.getActionKeys();
            for (ActionKey actionKey : actionKeys) {
                if (this.isActionOverriden(actionKey, addToCache)) continue;
                this.assertActionNotDuplicated(map, actionKey, method);
                map.put(actionKey, actionMethod);
                addToCache.put(actionKey, actionMethod);
            }
        }
    }

    private boolean isActionOverriden(ActionKey actionKey, Map<ActionKey, ActionMethod> addToCache) {
        return addToCache.containsKey(actionKey);
    }

    private void assertActionNotDuplicated(Map<ActionKey, ActionMethod> map, ActionKey actionKey, Method method) {
        if (map.get(actionKey) != null) {
            Method existingMethod = map.get(actionKey).getMethod();
            if (method.equals(existingMethod)) {
                return;
            }
            throw new RuntimeException("Trying to add two actions with the same name '" + actionKey + "' to " + this.endpointClazz.getName() + ": one at " + existingMethod.getDeclaringClass().getName() + " and the other at " + method.getDeclaringClass().getName());
        }
    }

    private ActionMethod createActionMethod(Method method) {
        try {
            return new ActionMethod(method);
        }
        catch (InvalidActionMethodException e) {
            throw new RuntimeException("Invalid Action: " + method.getDeclaringClass().getName() + "." + method.getName(), e);
        }
    }
}

