/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.scanner;

import io.yawp.repository.Feature;
import java.util.HashSet;
import java.util.Set;

public class FeatureTree<T extends Feature> {
    private Class<T> stopclazz;
    private Set<Class<? extends T>> nodes = new HashSet<Class<? extends T>>();
    private Set<Class<? extends T>> leafs = new HashSet<Class<? extends T>>();

    public FeatureTree(Class<T> stopclazz) {
        this.stopclazz = stopclazz;
    }

    public void add(Class<? extends T> clazz) {
        if (!this.nodes.contains(clazz)) {
            this.addNode(clazz);
            this.addLeaf(clazz);
        }
        this.addHierarchyNodes(clazz);
    }

    private void addHierarchyNodes(Class<? extends T> clazz) {
        Class<T> superclazz = clazz.getSuperclass();
        if (superclazz == null || superclazz.equals(this.stopclazz)) {
            return;
        }
        if (this.nodes.contains(superclazz)) {
            this.leafs.remove(superclazz);
            return;
        }
        this.addNode(superclazz);
    }

    private void addLeaf(Class<? extends T> clazz) {
        this.leafs.add(clazz);
    }

    private void addNode(Class<? extends T> clazz) {
        this.nodes.add(clazz);
    }

    public Set<Class<? extends T>> getLeafs() {
        return this.leafs;
    }

    public int size() {
        return this.nodes.size();
    }
}

