/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.scanner;

import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.repository.EndpointFeatures;
import io.yawp.repository.RepositoryFeatures;
import io.yawp.repository.actions.Action;
import io.yawp.repository.annotations.Endpoint;
import io.yawp.repository.hooks.Hook;
import io.yawp.repository.pipes.Pipe;
import io.yawp.repository.scanner.ActionLoader;
import io.yawp.repository.scanner.EndpointTree;
import io.yawp.repository.scanner.TransformerLoader;
import io.yawp.repository.shields.Shield;
import io.yawp.repository.transformers.Transformer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class RepositoryScanner {
    private static final Logger logger = Logger.getLogger(RepositoryScanner.class.getName());
    private boolean enableHooks;
    private String packagePrefix;
    private Reflections endpointsPackage;
    private Reflections yawpPackage;
    private Map<Class<?>, EndpointTree<?>> trees;

    @Deprecated
    public RepositoryScanner(String packagePrefix) {
        this.packagePrefix = packagePrefix;
        this.endpointsPackage = new Reflections(packagePrefix, new Scanner[0]);
        this.yawpPackage = new Reflections("io.yawp", new Scanner[0]);
        this.trees = new HashMap();
        this.enableHooks = true;
    }

    @Deprecated
    public RepositoryScanner enableHooks(boolean enableHooks) {
        this.enableHooks = enableHooks;
        return this;
    }

    public RepositoryFeatures scan() {
        long start = System.currentTimeMillis();
        RepositoryFeatures repositoryFeatures = new RepositoryFeatures(this.scanAndLoadAll());
        long elapsed = System.currentTimeMillis() - start;
        logger.info("YAWP! started in " + elapsed + " ms - package: " + this.packagePrefix);
        return repositoryFeatures;
    }

    private Map<Class<?>, EndpointFeatures<?>> scanAndLoadAll() {
        this.scanEndpoints();
        this.scanFeatures();
        return this.loadAll();
    }

    private void scanFeatures() {
        this.scanActions();
        this.scanTransformers();
        this.scanPipes();
        if (this.enableHooks) {
            this.scanHooks();
            this.scanShields();
        }
    }

    private Map<Class<?>, EndpointFeatures<?>> loadAll() {
        HashMap endpoints = new HashMap();
        ActionLoader actionLoader = new ActionLoader();
        TransformerLoader transformerLoader = new TransformerLoader();
        for (Class<?> endpointClazz : this.trees.keySet()) {
            EndpointTree<?> tree = this.trees.get(endpointClazz);
            EndpointFeatures endpoint = new EndpointFeatures(endpointClazz);
            actionLoader.load(endpoint, tree);
            transformerLoader.load(endpoint, tree);
            endpoint.setHooks(tree.loadHooks());
            endpoint.setShieldInfo(tree.loadShield());
            endpoint.setPipes(tree.loadPipes());
            endpoint.setPipesSink(tree.loadPipesSink());
            endpoints.put(endpointClazz, endpoint);
        }
        return endpoints;
    }

    private void scanEndpoints() {
        Set userClazzes = this.endpointsPackage.getTypesAnnotatedWith(Endpoint.class);
        for (Class endpointClazz : userClazzes) {
            this.trees.put(endpointClazz, new EndpointTree(endpointClazz));
        }
        Set yawpClazzes = this.yawpPackage.getTypesAnnotatedWith(Endpoint.class);
        for (Class endpointClazz : yawpClazzes) {
            this.trees.put(endpointClazz, new EndpointTree(endpointClazz));
        }
    }

    private List<Class<?>> findEndpointsInHierarchy(Class<?> parameterClazz, Class<?> featureClazz) {
        ArrayList clazzes = new ArrayList();
        for (Class<?> endpointClazz : this.trees.keySet()) {
            if (!this.isEndpointInTheHierarchy(endpointClazz, parameterClazz)) continue;
            clazzes.add(endpointClazz);
        }
        if (clazzes.isEmpty()) {
            throw new RuntimeException("Tryed to create feature '" + featureClazz.getName() + "' with entity '" + parameterClazz.getName() + "' that is not an @Endpoint nor a super class of one.");
        }
        return clazzes;
    }

    private <T> boolean isEndpointInTheHierarchy(Class<?> endpoint, Class<T> objectClazz) {
        return objectClazz.isAssignableFrom(endpoint);
    }

    private void scanActions() {
        Set clazzes = this.endpointsPackage.getSubTypesOf(Action.class);
        for (Class actionClazz : clazzes) {
            if (Modifier.isAbstract(actionClazz.getModifiers())) continue;
            this.addActionToEndpoints(actionClazz);
        }
    }

    private void addActionToEndpoints(Class<? extends Action> actionClazz) {
        Class<?> parameterClazz = ReflectionUtils.getFeatureEndpointClazz(actionClazz);
        if (parameterClazz == null) {
            return;
        }
        for (Class<?> endpointClazz : this.findEndpointsInHierarchy(parameterClazz, actionClazz)) {
            this.trees.get(endpointClazz).addAction(actionClazz);
        }
    }

    private void scanTransformers() {
        Set clazzes = this.endpointsPackage.getSubTypesOf(Transformer.class);
        for (Class transformerClazz : clazzes) {
            if (Modifier.isAbstract(transformerClazz.getModifiers())) continue;
            this.addTransformerToEndpoints(transformerClazz);
        }
    }

    private void addTransformerToEndpoints(Class<? extends Transformer> transformerClazz) {
        Class<?> parameterClazz = ReflectionUtils.getFeatureEndpointClazz(transformerClazz);
        if (parameterClazz == null) {
            return;
        }
        for (Class<?> endpointClazz : this.findEndpointsInHierarchy(parameterClazz, transformerClazz)) {
            this.trees.get(endpointClazz).addTransformer(transformerClazz);
        }
    }

    private void scanHooks() {
        Set clazzes = this.endpointsPackage.getSubTypesOf(Hook.class);
        for (Class hookClazz : clazzes) {
            if (Modifier.isAbstract(hookClazz.getModifiers())) continue;
            this.addHookToEndpoints(hookClazz);
        }
    }

    private <T, V extends Hook<T>> void addHookToEndpoints(Class<V> hookClazz) {
        Class<?> parameterClazz = ReflectionUtils.getFeatureEndpointClazz(hookClazz);
        if (parameterClazz == null) {
            return;
        }
        for (Class<?> endpointClazz : this.findEndpointsInHierarchy(parameterClazz, hookClazz)) {
            this.trees.get(endpointClazz).addHook(hookClazz);
        }
    }

    private void scanShields() {
        Set clazzes = this.endpointsPackage.getSubTypesOf(Shield.class);
        for (Class shieldClazz : clazzes) {
            if (Modifier.isAbstract(shieldClazz.getModifiers())) continue;
            this.addShieldToEndpoints(shieldClazz);
        }
    }

    private <T, V extends Shield<T>> void addShieldToEndpoints(Class<V> shieldClazz) {
        Class<?> parameterClazz = ReflectionUtils.getFeatureEndpointClazz(shieldClazz);
        if (parameterClazz == null) {
            return;
        }
        for (Class<?> endpointClazz : this.findEndpointsInHierarchy(parameterClazz, shieldClazz)) {
            this.trees.get(endpointClazz).addShield(shieldClazz);
        }
    }

    private void scanPipes() {
        Set clazzes = this.endpointsPackage.getSubTypesOf(Pipe.class);
        for (Class pipeClazz : clazzes) {
            if (Modifier.isAbstract(pipeClazz.getModifiers())) continue;
            this.addPipeToEndpoints(pipeClazz);
        }
    }

    private <T, S, V extends Pipe<T, S>> void addPipeToEndpoints(Class<V> pipeClazz) {
        Class<?> sourceClazz = ReflectionUtils.getFeatureEndpointClazz(pipeClazz);
        if (sourceClazz == null) {
            return;
        }
        for (Class<?> endpointClazz : this.findEndpointsInHierarchy(sourceClazz, pipeClazz)) {
            this.trees.get(endpointClazz).addPipe(pipeClazz);
        }
        Class<?> sinkClazz = ReflectionUtils.getFeatureTypeArgumentAt(pipeClazz, 1);
        this.trees.get(sinkClazz).addPipeSink(pipeClazz);
    }
}

